/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ConfigurationEntry;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.util.Environment;

public class EmbeddedGatewayCfg
extends GatewayCfg
implements ConfigurationEntry {
    private boolean enable = true;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase, Environment environment) {
        environment.getBool("ZEEBE_EMBED_GATEWAY").ifPresent(this::setEnable);
        NetworkCfg networkCfg = globalConfig.getNetwork();
        this.init(environment, networkCfg.getHost());
        this.getCluster().setContactPoint(networkCfg.getInternalApi().toSocketAddress().toString());
        this.getNetwork().setPort(this.getNetwork().getPort() + networkCfg.getPortOffset() * 10);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public EmbeddedGatewayCfg setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }
}

