/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ConfigurationEntry;
import io.zeebe.broker.system.configuration.ConfigurationUtil;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.util.DurationUtil;
import io.zeebe.util.Environment;
import java.time.Duration;

public class MetricsCfg
implements ConfigurationEntry {
    public static final int DEFAULT_PORT = 9600;
    private String reportingInterval = "5s";
    private String file = "metrics/zeebe.prom";
    private boolean enableHttpServer = false;
    private String host;
    private int port = 9600;

    @Override
    public void init(BrokerCfg brokerCfg, String brokerBase, Environment environment) {
        this.file = ConfigurationUtil.toAbsolutePath(this.file, brokerBase);
        environment.getBool("ZEEBE_METRICS_HTTP_SERVER").ifPresent(this::setEnableHttpServer);
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        if (this.host == null) {
            this.host = networkCfg.getHost();
        }
        this.port += networkCfg.getPortOffset() * 10;
    }

    public Duration getReportingIntervalDuration() {
        return DurationUtil.parse((String)this.reportingInterval);
    }

    public String getReportingInterval() {
        return this.reportingInterval;
    }

    public void setReportingInterval(String reportingInterval) {
        this.reportingInterval = reportingInterval;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String metricsFile) {
        this.file = metricsFile;
    }

    public boolean isEnableHttpServer() {
        return this.enableHttpServer;
    }

    public MetricsCfg setEnableHttpServer(boolean enableHttpServer) {
        this.enableHttpServer = enableHttpServer;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public MetricsCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MetricsCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public String toString() {
        return "MetricsCfg{reportingInterval='" + this.reportingInterval + '\'' + ", file='" + this.file + '\'' + ", enableHttpServer=" + this.enableHttpServer + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

