/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ConfigurationEntry;
import io.zeebe.broker.system.configuration.SocketBindingCommandApiCfg;
import io.zeebe.broker.system.configuration.SocketBindingInternalCfg;
import io.zeebe.util.Environment;

public class NetworkCfg
implements ConfigurationEntry {
    public static final String DEFAULT_HOST = "0.0.0.0";
    private String host = "0.0.0.0";
    private int portOffset = 0;
    private SocketBindingCommandApiCfg commandApi = new SocketBindingCommandApiCfg();
    private SocketBindingInternalCfg internalApi = new SocketBindingInternalCfg();

    @Override
    public void init(BrokerCfg brokerCfg, String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        this.commandApi.applyDefaults(this);
        this.internalApi.applyDefaults(this);
    }

    private void applyEnvironment(Environment environment) {
        environment.get("ZEEBE_HOST").ifPresent(v -> {
            this.host = v;
        });
        environment.getInt("ZEEBE_PORT_OFFSET").ifPresent(v -> {
            this.portOffset = v;
        });
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public SocketBindingCommandApiCfg getCommandApi() {
        return this.commandApi;
    }

    public void setCommandApi(SocketBindingCommandApiCfg commandApi) {
        this.commandApi = commandApi;
    }

    public SocketBindingInternalCfg getInternalApi() {
        return this.internalApi;
    }

    public void setInternalApi(SocketBindingInternalCfg internalApi) {
        this.internalApi = internalApi;
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + '\'' + ", portOffset=" + this.portOffset + ", commandApi=" + this.commandApi + ", internalApi=" + this.internalApi + '}';
    }
}

