/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.transport.SocketAddress;

public abstract class SocketBindingCfg {
    public static final String DEFAULT_SEND_BUFFER_SIZE = "16M";
    protected String host;
    protected int port;
    protected String sendBufferSize;

    public SocketAddress toSocketAddress() {
        return new SocketAddress(this.host, this.port);
    }

    public void applyDefaults(NetworkCfg networkCfg) {
        if (this.host == null) {
            this.host = networkCfg.getHost();
        }
        if (this.sendBufferSize == null) {
            this.sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
        }
        this.port += networkCfg.getPortOffset() * 10;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(String sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public String toString() {
        return "SocketBindingCfg{host='" + this.host + '\'' + ", port=" + this.port + ", sendBufferSize='" + this.sendBufferSize + '\'' + '}';
    }
}

