/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.management;

import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.system.management.deployment.PushDeploymentRequestHandler;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import java.util.function.Function;
import org.agrona.collections.Int2ObjectHashMap;

public class LeaderManagementRequestHandler
extends Actor
implements Service<LeaderManagementRequestHandler> {
    private final Injector<Atomix> atomixInjector = new Injector();
    private PushDeploymentRequestHandler pushDeploymentRequestHandler;
    private final ServiceGroupReference<Partition> leaderPartitionsGroupReference = ServiceGroupReference.create().onAdd((s, p) -> this.addPartition((Partition)p)).onRemove((s, p) -> this.removePartition((Partition)p)).build();
    private final Int2ObjectHashMap<Partition> leaderForPartitions = new Int2ObjectHashMap();
    private Atomix atomix;

    public void start(ServiceStartContext startContext) {
        this.atomix = (Atomix)this.atomixInjector.getValue();
        startContext.async(startContext.getScheduler().submitActor((Actor)this));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.actor.close());
    }

    protected void onActorStarting() {
        this.pushDeploymentRequestHandler = new PushDeploymentRequestHandler(this.leaderForPartitions, this.actor);
        this.atomix.getCommunicationService().subscribe("deployment", (Function)this.pushDeploymentRequestHandler);
    }

    public String getName() {
        return "management-request-handler";
    }

    public LeaderManagementRequestHandler get() {
        return this;
    }

    private void addPartition(Partition partition) {
        this.actor.submit(() -> {
            Partition cfr_ignored_0 = (Partition)this.leaderForPartitions.put(partition.getPartitionId(), (Object)partition);
        });
    }

    private void removePartition(Partition partition) {
        this.actor.submit(() -> {
            Partition cfr_ignored_0 = (Partition)this.leaderForPartitions.remove(partition.getPartitionId());
        });
    }

    public ServiceGroupReference<Partition> getLeaderPartitionsGroupReference() {
        return this.leaderPartitionsGroupReference;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }
}

