/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.metrics;

import io.zeebe.broker.Loggers;
import io.zeebe.util.FileUtil;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorPriority;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.slf4j.Logger;

public class MetricsFileWriter
extends Actor {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final MetricsManager metricsManager;
    private final Duration reportingInterval;
    private final String filePath;
    private final ExpandableDirectByteBuffer writeBuffer = new ExpandableDirectByteBuffer();
    private FileChannel fileChannel = null;

    public MetricsFileWriter(Duration reportingInterval, String filePath, MetricsManager metricsManager) {
        this.reportingInterval = reportingInterval;
        this.filePath = filePath;
        this.metricsManager = metricsManager;
    }

    public String getName() {
        return "metricsFileWriter";
    }

    protected void onActorStarting() {
        LOG.debug("Writing metrics to file {}. Reporting interval {}s.", (Object)this.filePath, (Object)(this.reportingInterval.toMillis() / 1000L));
        this.fileChannel = FileUtil.openChannel((String)this.filePath, (boolean)true);
        this.actor.setPriority(ActorPriority.LOW);
    }

    protected void onActorStarted() {
        this.actor.runAtFixedRate(this.reportingInterval, this::dump);
    }

    private void dump() {
        ActorClock clock = ActorClock.current();
        clock.update();
        int length = this.metricsManager.dump((MutableDirectBuffer)this.writeBuffer, 0, clock.getTimeMillis());
        ByteBuffer inBuffer = this.writeBuffer.byteBuffer();
        inBuffer.position(0);
        inBuffer.limit(length);
        try {
            this.fileChannel.position(0L);
            this.fileChannel.truncate(length);
            while (inBuffer.hasRemaining()) {
                this.fileChannel.write(inBuffer);
            }
            this.fileChannel.force(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void onActorClosing() {
        FileUtil.closeSilently((Closeable)this.fileChannel);
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }
}

