/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.metrics;

import io.zeebe.broker.system.configuration.MetricsCfg;
import io.zeebe.broker.system.metrics.MetricsFileWriter;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.SchedulingHints;

public class MetricsFileWriterService
implements Service<MetricsFileWriter> {
    private MetricsFileWriter metricsFileWriter;
    private MetricsCfg configuration;

    public MetricsFileWriterService(MetricsCfg cfg) {
        this.configuration = cfg;
    }

    public void start(ServiceStartContext startContext) {
        ActorScheduler scheduler = startContext.getScheduler();
        MetricsManager metricsManager = startContext.getScheduler().getMetricsManager();
        String metricsFileName = this.configuration.getFile();
        this.metricsFileWriter = new MetricsFileWriter(this.configuration.getReportingIntervalDuration(), metricsFileName, metricsManager);
        startContext.async(scheduler.submitActor((Actor)this.metricsFileWriter, true, SchedulingHints.ioBound()));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.metricsFileWriter.close());
    }

    public MetricsFileWriter get() {
        return this.metricsFileWriter;
    }
}

