/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.metrics;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.zeebe.broker.system.metrics.MetricsHttpServerInitializer;
import io.zeebe.util.metrics.MetricsManager;

public class MetricsHttpServer
implements AutoCloseable {
    private final NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Channel channel;

    public MetricsHttpServer(MetricsManager metricsManager, String host, int port) {
        this.channel = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new MetricsHttpServerInitializer(metricsManager)).bind(host, port).syncUninterruptibly().channel();
    }

    @Override
    public void close() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.channel.close().syncUninterruptibly();
    }
}

