/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.metrics;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.zeebe.util.metrics.MetricsManager;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;

public class MetricsHttpServerHandler
extends ChannelInboundHandlerAdapter {
    private final MutableDirectBuffer metricsBuffer = new ExpandableDirectByteBuffer();
    private final MetricsManager metricsManager;

    public MetricsHttpServerHandler(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            super.channelRead(ctx, msg);
            return;
        }
        HttpRequest request = (HttpRequest)msg;
        if (!request.decoderResult().isSuccess()) {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (request.method() != HttpMethod.GET) {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED));
            return;
        }
        int length = this.metricsManager.dump(this.metricsBuffer, 0, Instant.now().toEpochMilli());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((ByteBuffer)this.metricsBuffer.byteBuffer()).slice(0, length));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)HttpUtil.isKeepAlive((HttpMessage)request));
        ctx.writeAndFlush((Object)response);
    }
}

