/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.broker.Loggers;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.Transports;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.ActorScheduler;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public class BufferingServerTransportService
implements Service<BufferingServerTransport> {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final Injector<Dispatcher> receiveBufferInjector = new Injector();
    protected final String readableName;
    protected final InetSocketAddress bindAddress;
    private final ByteValue sendBufferSize;
    protected BufferingServerTransport serverTransport;

    public BufferingServerTransportService(String readableName, InetSocketAddress bindAddress, ByteValue sendBufferSize) {
        this.readableName = readableName;
        this.bindAddress = bindAddress;
        this.sendBufferSize = sendBufferSize;
    }

    public void start(ServiceStartContext serviceContext) {
        ActorScheduler scheduler = serviceContext.getScheduler();
        Dispatcher receiveBuffer = (Dispatcher)this.receiveBufferInjector.getValue();
        this.serverTransport = Transports.newServerTransport().name(this.readableName).bindAddress(this.bindAddress).messageMemoryPool((TransportMemoryPool)new NonBlockingMemoryPool(this.sendBufferSize)).scheduler(scheduler).buildBuffering(receiveBuffer);
        LOG.info("Bound {} to {}", (Object)this.readableName, (Object)this.bindAddress);
    }

    public void stop(ServiceStopContext serviceStopContext) {
        serviceStopContext.async(this.serverTransport.closeAsync());
    }

    public BufferingServerTransport get() {
        return this.serverTransport;
    }

    public Injector<Dispatcher> getReceiveBufferInjector() {
        return this.receiveBufferInjector;
    }

    public Closeable getReleasingResourcesDelegate() {
        return () -> {
            if (this.serverTransport != null) {
                this.serverTransport.releaseResources();
            }
        };
    }
}

