/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.ClientTransportBuilder;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.Transports;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.transport.impl.memory.UnboundedMemoryPool;
import io.zeebe.util.ByteValue;
import io.zeebe.util.collection.IntTuple;
import io.zeebe.util.sched.ActorScheduler;
import java.util.Collection;

public class ClientTransportService
implements Service<ClientTransport> {
    private final String name;
    protected final Collection<IntTuple<SocketAddress>> defaultEndpoints;
    private final ByteValue messageBufferSize;
    protected ClientTransport transport;

    public ClientTransportService(String name, Collection<IntTuple<SocketAddress>> defaultEndpoints, ByteValue messageBufferSize) {
        this.name = name;
        this.defaultEndpoints = defaultEndpoints;
        this.messageBufferSize = messageBufferSize;
    }

    public void start(ServiceStartContext startContext) {
        ActorScheduler scheduler = startContext.getScheduler();
        ClientTransportBuilder transportBuilder = Transports.newClientTransport((String)this.name);
        this.transport = transportBuilder.messageMemoryPool((TransportMemoryPool)new NonBlockingMemoryPool(this.messageBufferSize)).requestMemoryPool((TransportMemoryPool)new UnboundedMemoryPool()).scheduler(scheduler).build();
        if (this.defaultEndpoints != null) {
            this.defaultEndpoints.forEach(s -> this.transport.registerEndpoint(s.getInt(), (SocketAddress)s.getRight()));
        }
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.transport.closeAsync());
    }

    public ClientTransport get() {
        return this.transport;
    }
}

