/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.Transports;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.ActorScheduler;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public class ServerTransportService
implements Service<ServerTransport> {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final Injector<ServerRequestHandler> requestHandlerInjector = new Injector();
    protected final Injector<ServerMessageHandler> messageHandlerInjector = new Injector();
    protected final String readableName;
    protected final InetSocketAddress bindAddress;
    private final ByteValue sendBufferSize;
    protected ServerTransport serverTransport;

    public ServerTransportService(String readableName, InetSocketAddress bindAddress, ByteValue sendBufferSize) {
        this.readableName = readableName;
        this.bindAddress = bindAddress;
        this.sendBufferSize = sendBufferSize;
    }

    public void start(ServiceStartContext serviceContext) {
        ActorScheduler scheduler = serviceContext.getScheduler();
        ServerRequestHandler requestHandler = (ServerRequestHandler)this.requestHandlerInjector.getValue();
        ServerMessageHandler messageHandler = (ServerMessageHandler)this.messageHandlerInjector.getValue();
        this.serverTransport = Transports.newServerTransport().name(this.readableName).bindAddress(this.bindAddress).scheduler(scheduler).messageMemoryPool((TransportMemoryPool)new NonBlockingMemoryPool(this.sendBufferSize)).build(messageHandler, requestHandler);
        LOG.info("Bound {} to {}", (Object)this.readableName, (Object)this.bindAddress);
    }

    public void stop(ServiceStopContext serviceStopContext) {
        serviceStopContext.async(this.serverTransport.closeAsync());
    }

    public ServerTransport get() {
        return this.serverTransport;
    }

    public Closeable getReleasingResourcesDelegate() {
        return () -> {
            if (this.serverTransport != null) {
                this.serverTransport.releaseResources();
            }
        };
    }

    public Injector<ServerRequestHandler> getRequestHandlerInjector() {
        return this.requestHandlerInjector;
    }

    public Injector<ServerMessageHandler> getMessageHandlerInjector() {
        return this.messageHandlerInjector;
    }
}

