/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.broker.clustering.base.ClusterBaseLayerServiceNames;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.broker.system.configuration.SocketBindingCfg;
import io.zeebe.broker.transport.ServerTransportService;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.broker.transport.commandapi.CommandApiMessageHandlerService;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.future.ActorFuture;
import java.net.InetSocketAddress;

public class TransportComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        this.createSocketBindings(context);
    }

    private void createSocketBindings(SystemContext context) {
        NetworkCfg networkCfg = context.getBrokerConfiguration().getNetwork();
        ServiceContainer serviceContainer = context.getServiceContainer();
        ActorFuture<ServerTransport> commandApiFuture = this.bindNonBufferingProtocolEndpoint(context, serviceContainer, "commandApi.server", networkCfg.getCommandApi(), TransportServiceNames.COMMAND_API_MESSAGE_HANDLER, TransportServiceNames.COMMAND_API_MESSAGE_HANDLER);
        context.addRequiredStartAction(commandApiFuture);
        CommandApiMessageHandlerService messageHandlerService = new CommandApiMessageHandlerService();
        serviceContainer.createService(TransportServiceNames.COMMAND_API_MESSAGE_HANDLER, (Service)messageHandlerService).groupReference(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME, messageHandlerService.getLeaderParitionsGroupReference()).install();
    }

    protected ActorFuture<ServerTransport> bindNonBufferingProtocolEndpoint(SystemContext systemContext, ServiceContainer serviceContainer, String name, SocketBindingCfg socketBindingCfg, ServiceName<? extends ServerRequestHandler> requestHandlerService, ServiceName<? extends ServerMessageHandler> messageHandlerService) {
        SocketAddress bindAddr = socketBindingCfg.toSocketAddress();
        return this.createServerTransport(systemContext, serviceContainer, name, bindAddr.toInetSocketAddress(), new ByteValue(socketBindingCfg.getSendBufferSize()), requestHandlerService, messageHandlerService);
    }

    protected ActorFuture<ServerTransport> createServerTransport(SystemContext systemContext, ServiceContainer serviceContainer, String name, InetSocketAddress bindAddress, ByteValue sendBufferSize, ServiceName<? extends ServerRequestHandler> requestHandlerDependency, ServiceName<? extends ServerMessageHandler> messageHandlerDependency) {
        ServerTransportService service = new ServerTransportService(name, bindAddress, sendBufferSize);
        systemContext.addResourceReleasingDelegate(service.getReleasingResourcesDelegate());
        return serviceContainer.createService(TransportServiceNames.serverTransport(name), (Service)service).dependency(requestHandlerDependency, service.getRequestHandlerInjector()).dependency(messageHandlerDependency, service.getMessageHandlerInjector()).install();
    }
}

