/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.commandapi;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.transport.commandapi.ErrorResponseWriter;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.logstreams.log.LogStreamWriterImpl;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceCreationRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.util.buffer.BufferWriter;
import java.util.EnumMap;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.slf4j.Logger;

public class CommandApiMessageHandler
implements ServerMessageHandler,
ServerRequestHandler {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    protected final ExecuteCommandRequestDecoder executeCommandRequestDecoder = new ExecuteCommandRequestDecoder();
    protected final ManyToOneConcurrentLinkedQueue<Runnable> cmdQueue = new ManyToOneConcurrentLinkedQueue();
    protected final Consumer<Runnable> cmdConsumer = Runnable::run;
    protected final Int2ObjectHashMap<LogStream> leadingStreams = new Int2ObjectHashMap();
    protected final RecordMetadata eventMetadata = new RecordMetadata();
    protected final LogStreamRecordWriter logStreamWriter = new LogStreamWriterImpl();
    protected final ErrorResponseWriter errorResponseWriter = new ErrorResponseWriter();
    protected final EnumMap<ValueType, UnpackedObject> recordsByType = new EnumMap(ValueType.class);

    public CommandApiMessageHandler() {
        this.initEventTypeMap();
    }

    private void initEventTypeMap() {
        this.recordsByType.put(ValueType.DEPLOYMENT, (UnpackedObject)new DeploymentRecord());
        this.recordsByType.put(ValueType.JOB, (UnpackedObject)new JobRecord());
        this.recordsByType.put(ValueType.WORKFLOW_INSTANCE, (UnpackedObject)new WorkflowInstanceRecord());
        this.recordsByType.put(ValueType.MESSAGE, (UnpackedObject)new MessageRecord());
        this.recordsByType.put(ValueType.JOB_BATCH, (UnpackedObject)new JobBatchRecord());
        this.recordsByType.put(ValueType.INCIDENT, (UnpackedObject)new IncidentRecord());
        this.recordsByType.put(ValueType.VARIABLE_DOCUMENT, (UnpackedObject)new VariableDocumentRecord());
        this.recordsByType.put(ValueType.WORKFLOW_INSTANCE_CREATION, (UnpackedObject)new WorkflowInstanceCreationRecord());
    }

    private boolean handleExecuteCommandRequest(ServerOutput output, RemoteAddress requestAddress, long requestId, RecordMetadata eventMetadata, DirectBuffer buffer, int messageOffset, int messageLength) {
        this.executeCommandRequestDecoder.wrap(buffer, messageOffset + this.messageHeaderDecoder.encodedLength(), this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        int partitionId = this.executeCommandRequestDecoder.partitionId();
        long key = this.executeCommandRequestDecoder.key();
        LogStream logStream = (LogStream)this.leadingStreams.get(partitionId);
        if (logStream == null) {
            return this.errorResponseWriter.partitionLeaderMismatch(partitionId).tryWriteResponseOrLogFailure(output, requestAddress.getStreamId(), requestId);
        }
        ValueType eventType = this.executeCommandRequestDecoder.valueType();
        short intent = this.executeCommandRequestDecoder.intent();
        UnpackedObject event = this.recordsByType.get(eventType);
        if (event == null) {
            return this.errorResponseWriter.unsupportedMessage(eventType.name(), this.recordsByType.keySet().toArray()).tryWriteResponseOrLogFailure(output, requestAddress.getStreamId(), requestId);
        }
        int eventOffset = this.executeCommandRequestDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();
        int eventLength = this.executeCommandRequestDecoder.valueLength();
        event.reset();
        try {
            event.wrap(buffer, eventOffset, eventLength);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to deserialize message of type {} in client API", (Object)eventType.name(), (Object)e);
            return this.errorResponseWriter.malformedRequest(e).tryWriteResponseOrLogFailure(output, requestAddress.getStreamId(), requestId);
        }
        eventMetadata.partitionId(partitionId);
        eventMetadata.recordType(RecordType.COMMAND);
        eventMetadata.intent(Intent.fromProtocolValue((ValueType)eventType, (short)intent));
        eventMetadata.valueType(eventType);
        this.logStreamWriter.wrap(logStream);
        if (key != ExecuteCommandRequestDecoder.keyNullValue()) {
            this.logStreamWriter.key(key);
        } else {
            this.logStreamWriter.keyNull();
        }
        long eventPosition = this.logStreamWriter.metadataWriter((BufferWriter)eventMetadata).value(buffer, eventOffset, eventLength).tryWrite();
        return eventPosition >= 0L;
    }

    public void addPartition(LogStream logStream) {
        this.cmdQueue.add(() -> {
            LogStream cfr_ignored_0 = (LogStream)this.leadingStreams.put(logStream.getPartitionId(), (Object)logStream);
        });
    }

    public void removePartition(LogStream logStream) {
        this.cmdQueue.add(() -> {
            LogStream cfr_ignored_0 = (LogStream)this.leadingStreams.remove(logStream.getPartitionId());
        });
    }

    public boolean onRequest(ServerOutput output, RemoteAddress remoteAddress, DirectBuffer buffer, int offset, int length, long requestId) {
        this.drainCommandQueue();
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        int clientVersion = this.messageHeaderDecoder.version();
        if (clientVersion > 1) {
            return this.errorResponseWriter.invalidClientVersion(1, clientVersion).tryWriteResponse(output, remoteAddress.getStreamId(), requestId);
        }
        this.eventMetadata.reset();
        this.eventMetadata.protocolVersion(clientVersion);
        this.eventMetadata.requestId(requestId);
        this.eventMetadata.requestStreamId(remoteAddress.getStreamId());
        if (templateId == 20) {
            return this.handleExecuteCommandRequest(output, remoteAddress, requestId, this.eventMetadata, buffer, offset, length);
        }
        return this.errorResponseWriter.invalidMessageTemplate(templateId, 20).tryWriteResponse(output, remoteAddress.getStreamId(), requestId);
    }

    public boolean onMessage(ServerOutput output, RemoteAddress remoteAddress, DirectBuffer buffer, int offset, int length) {
        return true;
    }

    private void drainCommandQueue() {
        while (!this.cmdQueue.isEmpty()) {
            Runnable runnable = (Runnable)this.cmdQueue.poll();
            if (runnable == null) continue;
            this.cmdConsumer.accept(runnable);
        }
    }
}

