/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class LogReplicationRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 17;
    public static final int TEMPLATE_ID = 16;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LogReplicationRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 17;
    }

    public int sbeTemplateId() {
        return 16;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LogReplicationRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int fromPositionId() {
        return 0;
    }

    public static int fromPositionSinceVersion() {
        return 0;
    }

    public static int fromPositionEncodingOffset() {
        return 0;
    }

    public static int fromPositionEncodingLength() {
        return 8;
    }

    public static String fromPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long fromPositionNullValue() {
        return -1L;
    }

    public static long fromPositionMinValue() {
        return 0L;
    }

    public static long fromPositionMaxValue() {
        return -2L;
    }

    public long fromPosition() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int toPositionId() {
        return 1;
    }

    public static int toPositionSinceVersion() {
        return 0;
    }

    public static int toPositionEncodingOffset() {
        return 8;
    }

    public static int toPositionEncodingLength() {
        return 8;
    }

    public static String toPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long toPositionNullValue() {
        return -1L;
    }

    public static long toPositionMinValue() {
        return 0L;
    }

    public static long toPositionMaxValue() {
        return -2L;
    }

    public long toPosition() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int includeFromPositionId() {
        return 2;
    }

    public static int includeFromPositionSinceVersion() {
        return 0;
    }

    public static int includeFromPositionEncodingOffset() {
        return 16;
    }

    public static int includeFromPositionEncodingLength() {
        return 1;
    }

    public static String includeFromPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public BooleanType includeFromPosition() {
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 16) & 0xFF));
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[LogReplicationRequest](sbeTemplateId=");
        builder.append(16);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 17) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(17);
        builder.append("):");
        builder.append("fromPosition=");
        builder.append(this.fromPosition());
        builder.append('|');
        builder.append("toPosition=");
        builder.append(this.toPosition());
        builder.append('|');
        builder.append("includeFromPosition=");
        builder.append((Object)this.includeFromPosition());
        this.limit(originalLimit);
        return builder;
    }
}

