/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.LogReplicationRequestDecoder;
import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class LogReplicationRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 17;
    public static final int TEMPLATE_ID = 16;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LogReplicationRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 17;
    }

    public int sbeTemplateId() {
        return 16;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LogReplicationRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 17);
        return this;
    }

    public LogReplicationRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(17).templateId(16).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int fromPositionId() {
        return 0;
    }

    public static int fromPositionSinceVersion() {
        return 0;
    }

    public static int fromPositionEncodingOffset() {
        return 0;
    }

    public static int fromPositionEncodingLength() {
        return 8;
    }

    public static String fromPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long fromPositionNullValue() {
        return -1L;
    }

    public static long fromPositionMinValue() {
        return 0L;
    }

    public static long fromPositionMaxValue() {
        return -2L;
    }

    public LogReplicationRequestEncoder fromPosition(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int toPositionId() {
        return 1;
    }

    public static int toPositionSinceVersion() {
        return 0;
    }

    public static int toPositionEncodingOffset() {
        return 8;
    }

    public static int toPositionEncodingLength() {
        return 8;
    }

    public static String toPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long toPositionNullValue() {
        return -1L;
    }

    public static long toPositionMinValue() {
        return 0L;
    }

    public static long toPositionMaxValue() {
        return -2L;
    }

    public LogReplicationRequestEncoder toPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int includeFromPositionId() {
        return 2;
    }

    public static int includeFromPositionSinceVersion() {
        return 0;
    }

    public static int includeFromPositionEncodingOffset() {
        return 16;
    }

    public static int includeFromPositionEncodingLength() {
        return 1;
    }

    public static String includeFromPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public LogReplicationRequestEncoder includeFromPosition(BooleanType value) {
        this.buffer.putByte(this.offset + 16, (byte)value.value());
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        LogReplicationRequestDecoder writer = new LogReplicationRequestDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 17, 1);
        return writer.appendTo(builder);
    }
}

