/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.LogReplicationResponseDecoder;
import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class LogReplicationResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 9;
    public static final int TEMPLATE_ID = 17;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LogReplicationResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 9;
    }

    public int sbeTemplateId() {
        return 17;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LogReplicationResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 9);
        return this;
    }

    public LogReplicationResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(9).templateId(17).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int toPositionId() {
        return 0;
    }

    public static int toPositionSinceVersion() {
        return 0;
    }

    public static int toPositionEncodingOffset() {
        return 0;
    }

    public static int toPositionEncodingLength() {
        return 8;
    }

    public static String toPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long toPositionNullValue() {
        return -1L;
    }

    public static long toPositionMinValue() {
        return 0L;
    }

    public static long toPositionMaxValue() {
        return -2L;
    }

    public LogReplicationResponseEncoder toPosition(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int moreAvailableId() {
        return 1;
    }

    public static int moreAvailableSinceVersion() {
        return 0;
    }

    public static int moreAvailableEncodingOffset() {
        return 8;
    }

    public static int moreAvailableEncodingLength() {
        return 1;
    }

    public static String moreAvailableMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public LogReplicationResponseEncoder moreAvailable(BooleanType value) {
        this.buffer.putByte(this.offset + 8, (byte)value.value());
        return this;
    }

    public static int serializedEventsId() {
        return 2;
    }

    public static String serializedEventsMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int serializedEventsHeaderLength() {
        return 4;
    }

    public LogReplicationResponseEncoder putSerializedEvents(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public LogReplicationResponseEncoder putSerializedEvents(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        LogReplicationResponseDecoder writer = new LogReplicationResponseDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 9, 1);
        return writer.appendTo(builder);
    }
}

