/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class NotLeaderResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NotLeaderResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public NotLeaderResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[NotLeaderResponse](sbeTemplateId=");
        builder.append(5);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 0) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(0);
        builder.append("):");
        this.limit(originalLimit);
        return builder;
    }
}

