/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class PushDeploymentResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 10;
    public static final int TEMPLATE_ID = 14;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PushDeploymentResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 10;
    }

    public int sbeTemplateId() {
        return 14;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public PushDeploymentResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 0;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public int partitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int deploymentKeyId() {
        return 1;
    }

    public static int deploymentKeySinceVersion() {
        return 0;
    }

    public static int deploymentKeyEncodingOffset() {
        return 2;
    }

    public static int deploymentKeyEncodingLength() {
        return 8;
    }

    public static String deploymentKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long deploymentKeyNullValue() {
        return -1L;
    }

    public static long deploymentKeyMinValue() {
        return 0L;
    }

    public static long deploymentKeyMaxValue() {
        return -2L;
    }

    public long deploymentKey() {
        return this.buffer.getLong(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[PushDeploymentResponse](sbeTemplateId=");
        builder.append(14);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 10) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(10);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(this.partitionId());
        builder.append('|');
        builder.append("deploymentKey=");
        builder.append(this.deploymentKey());
        this.limit(originalLimit);
        return builder;
    }
}

