/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import io.zeebe.clustering.management.RestoreInfoRequestDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class RestoreInfoRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 18;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RestoreInfoRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 18;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RestoreInfoRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 16);
        return this;
    }

    public RestoreInfoRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(16).templateId(18).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int latestLocalPositionId() {
        return 0;
    }

    public static int latestLocalPositionSinceVersion() {
        return 0;
    }

    public static int latestLocalPositionEncodingOffset() {
        return 0;
    }

    public static int latestLocalPositionEncodingLength() {
        return 8;
    }

    public static String latestLocalPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long latestLocalPositionNullValue() {
        return -1L;
    }

    public static long latestLocalPositionMinValue() {
        return 0L;
    }

    public static long latestLocalPositionMaxValue() {
        return -2L;
    }

    public RestoreInfoRequestEncoder latestLocalPosition(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int backupPositionId() {
        return 1;
    }

    public static int backupPositionSinceVersion() {
        return 0;
    }

    public static int backupPositionEncodingOffset() {
        return 8;
    }

    public static int backupPositionEncodingLength() {
        return 8;
    }

    public static String backupPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long backupPositionNullValue() {
        return -1L;
    }

    public static long backupPositionMinValue() {
        return 0L;
    }

    public static long backupPositionMaxValue() {
        return -2L;
    }

    public RestoreInfoRequestEncoder backupPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        RestoreInfoRequestDecoder writer = new RestoreInfoRequestDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 16, 1);
        return writer.appendTo(builder);
    }
}

