/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class RestoreInfoResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 11;
    public static final int TEMPLATE_ID = 19;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RestoreInfoResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 11;
    }

    public int sbeTemplateId() {
        return 19;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RestoreInfoResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int replicationTargetId() {
        return 0;
    }

    public static int replicationTargetSinceVersion() {
        return 0;
    }

    public static int replicationTargetEncodingOffset() {
        return 0;
    }

    public static int replicationTargetEncodingLength() {
        return 1;
    }

    public static String replicationTargetMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static short replicationTargetNullValue() {
        return 255;
    }

    public static short replicationTargetMinValue() {
        return 0;
    }

    public static short replicationTargetMaxValue() {
        return 254;
    }

    public short replicationTarget() {
        return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
    }

    public static int snapshotIdId() {
        return 1;
    }

    public static int snapshotIdSinceVersion() {
        return 0;
    }

    public static int snapshotIdEncodingOffset() {
        return 1;
    }

    public static int snapshotIdEncodingLength() {
        return 8;
    }

    public static String snapshotIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long snapshotIdNullValue() {
        return -1L;
    }

    public static long snapshotIdMinValue() {
        return 0L;
    }

    public static long snapshotIdMaxValue() {
        return -2L;
    }

    public long snapshotId() {
        return this.buffer.getLong(this.offset + 1, ByteOrder.LITTLE_ENDIAN);
    }

    public static int numChunksId() {
        return 2;
    }

    public static int numChunksSinceVersion() {
        return 0;
    }

    public static int numChunksEncodingOffset() {
        return 9;
    }

    public static int numChunksEncodingLength() {
        return 2;
    }

    public static String numChunksMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int numChunksNullValue() {
        return 65535;
    }

    public static int numChunksMinValue() {
        return 0;
    }

    public static int numChunksMaxValue() {
        return 65534;
    }

    public int numChunks() {
        return this.buffer.getShort(this.offset + 9, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[RestoreInfoResponse](sbeTemplateId=");
        builder.append(19);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 11) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(11);
        builder.append("):");
        builder.append("replicationTarget=");
        builder.append(this.replicationTarget());
        builder.append('|');
        builder.append("snapshotId=");
        builder.append(this.snapshotId());
        builder.append('|');
        builder.append("numChunks=");
        builder.append(this.numChunks());
        this.limit(originalLimit);
        return builder;
    }
}

