/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import io.zeebe.clustering.management.RestoreInfoResponseDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class RestoreInfoResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 11;
    public static final int TEMPLATE_ID = 19;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RestoreInfoResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 11;
    }

    public int sbeTemplateId() {
        return 19;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RestoreInfoResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 11);
        return this;
    }

    public RestoreInfoResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(11).templateId(19).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int replicationTargetId() {
        return 0;
    }

    public static int replicationTargetSinceVersion() {
        return 0;
    }

    public static int replicationTargetEncodingOffset() {
        return 0;
    }

    public static int replicationTargetEncodingLength() {
        return 1;
    }

    public static String replicationTargetMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static short replicationTargetNullValue() {
        return 255;
    }

    public static short replicationTargetMinValue() {
        return 0;
    }

    public static short replicationTargetMaxValue() {
        return 254;
    }

    public RestoreInfoResponseEncoder replicationTarget(short value) {
        this.buffer.putByte(this.offset + 0, (byte)value);
        return this;
    }

    public static int snapshotIdId() {
        return 1;
    }

    public static int snapshotIdSinceVersion() {
        return 0;
    }

    public static int snapshotIdEncodingOffset() {
        return 1;
    }

    public static int snapshotIdEncodingLength() {
        return 8;
    }

    public static String snapshotIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long snapshotIdNullValue() {
        return -1L;
    }

    public static long snapshotIdMinValue() {
        return 0L;
    }

    public static long snapshotIdMaxValue() {
        return -2L;
    }

    public RestoreInfoResponseEncoder snapshotId(long value) {
        this.buffer.putLong(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numChunksId() {
        return 2;
    }

    public static int numChunksSinceVersion() {
        return 0;
    }

    public static int numChunksEncodingOffset() {
        return 9;
    }

    public static int numChunksEncodingLength() {
        return 2;
    }

    public static String numChunksMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int numChunksNullValue() {
        return 65535;
    }

    public static int numChunksMinValue() {
        return 0;
    }

    public static int numChunksMaxValue() {
        return 65534;
    }

    public RestoreInfoResponseEncoder numChunks(int value) {
        this.buffer.putShort(this.offset + 9, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        RestoreInfoResponseDecoder writer = new RestoreInfoResponseDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 11, 1);
        return writer.appendTo(builder);
    }
}

