/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class SnapshotChunkDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 15;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotChunkDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 15;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotChunkDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int snapshotPositionId() {
        return 0;
    }

    public static int snapshotPositionSinceVersion() {
        return 0;
    }

    public static int snapshotPositionEncodingOffset() {
        return 0;
    }

    public static int snapshotPositionEncodingLength() {
        return 8;
    }

    public static String snapshotPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long snapshotPositionNullValue() {
        return -1L;
    }

    public static long snapshotPositionMinValue() {
        return 0L;
    }

    public static long snapshotPositionMaxValue() {
        return -2L;
    }

    public long snapshotPosition() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int totalCountId() {
        return 1;
    }

    public static int totalCountSinceVersion() {
        return 0;
    }

    public static int totalCountEncodingOffset() {
        return 8;
    }

    public static int totalCountEncodingLength() {
        return 4;
    }

    public static String totalCountMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int totalCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int totalCountMinValue() {
        return -2147483647;
    }

    public static int totalCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int totalCount() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int checksumId() {
        return 2;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 12;
    }

    public static int checksumEncodingLength() {
        return 8;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long checksumNullValue() {
        return -1L;
    }

    public static long checksumMinValue() {
        return 0L;
    }

    public static long checksumMaxValue() {
        return -2L;
    }

    public long checksum() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int chunkNameId() {
        return 3;
    }

    public static int chunkNameSinceVersion() {
        return 0;
    }

    public static String chunkNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String chunkNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int chunkNameHeaderLength() {
        return 2;
    }

    public int chunkNameLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getChunkName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getChunkName(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapChunkName(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String chunkName() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int contentId() {
        return 4;
    }

    public static int contentSinceVersion() {
        return 0;
    }

    public static String contentMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int contentHeaderLength() {
        return 4;
    }

    public int contentLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getContent(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getContent(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapContent(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[SnapshotChunk](sbeTemplateId=");
        builder.append(15);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 20) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(20);
        builder.append("):");
        builder.append("snapshotPosition=");
        builder.append(this.snapshotPosition());
        builder.append('|');
        builder.append("totalCount=");
        builder.append(this.totalCount());
        builder.append('|');
        builder.append("checksum=");
        builder.append(this.checksum());
        builder.append('|');
        builder.append("chunkName=");
        builder.append('\'' + this.chunkName() + '\'');
        builder.append('|');
        builder.append("content=");
        builder.append(this.contentLength() + " bytes of raw data");
        this.parentMessage.limit(this.parentMessage.limit() + SnapshotChunkDecoder.contentHeaderLength() + this.contentLength());
        this.limit(originalLimit);
        return builder;
    }
}

