/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import io.zeebe.clustering.management.SnapshotChunkDecoder;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public class SnapshotChunkEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 15;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotChunkEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 15;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotChunkEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public SnapshotChunkEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(15).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int snapshotPositionId() {
        return 0;
    }

    public static int snapshotPositionSinceVersion() {
        return 0;
    }

    public static int snapshotPositionEncodingOffset() {
        return 0;
    }

    public static int snapshotPositionEncodingLength() {
        return 8;
    }

    public static String snapshotPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long snapshotPositionNullValue() {
        return -1L;
    }

    public static long snapshotPositionMinValue() {
        return 0L;
    }

    public static long snapshotPositionMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder snapshotPosition(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int totalCountId() {
        return 1;
    }

    public static int totalCountSinceVersion() {
        return 0;
    }

    public static int totalCountEncodingOffset() {
        return 8;
    }

    public static int totalCountEncodingLength() {
        return 4;
    }

    public static String totalCountMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int totalCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int totalCountMinValue() {
        return -2147483647;
    }

    public static int totalCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SnapshotChunkEncoder totalCount(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int checksumId() {
        return 2;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 12;
    }

    public static int checksumEncodingLength() {
        return 8;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long checksumNullValue() {
        return -1L;
    }

    public static long checksumMinValue() {
        return 0L;
    }

    public static long checksumMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder checksum(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int chunkNameId() {
        return 3;
    }

    public static String chunkNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String chunkNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int chunkNameHeaderLength() {
        return 2;
    }

    public SnapshotChunkEncoder putChunkName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder putChunkName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder chunkName(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int contentId() {
        return 4;
    }

    public static String contentMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int contentHeaderLength() {
        return 4;
    }

    public SnapshotChunkEncoder putContent(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder putContent(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        SnapshotChunkDecoder writer = new SnapshotChunkDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 20, 1);
        return writer.appendTo(builder);
    }
}

