/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.clustering.management.MetaAttribute;
import io.zeebe.clustering.management.SnapshotRestoreRequestDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class SnapshotRestoreRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 10;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotRestoreRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 10;
    }

    public int sbeTemplateId() {
        return 20;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotRestoreRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 10);
        return this;
    }

    public SnapshotRestoreRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(10).templateId(20).schemaId(5).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int snapshotIdId() {
        return 0;
    }

    public static int snapshotIdSinceVersion() {
        return 0;
    }

    public static int snapshotIdEncodingOffset() {
        return 0;
    }

    public static int snapshotIdEncodingLength() {
        return 8;
    }

    public static String snapshotIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long snapshotIdNullValue() {
        return -1L;
    }

    public static long snapshotIdMinValue() {
        return 0L;
    }

    public static long snapshotIdMaxValue() {
        return -2L;
    }

    public SnapshotRestoreRequestEncoder snapshotId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int chunkIdxId() {
        return 1;
    }

    public static int chunkIdxSinceVersion() {
        return 0;
    }

    public static int chunkIdxEncodingOffset() {
        return 8;
    }

    public static int chunkIdxEncodingLength() {
        return 2;
    }

    public static String chunkIdxMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int chunkIdxNullValue() {
        return 65535;
    }

    public static int chunkIdxMinValue() {
        return 0;
    }

    public static int chunkIdxMaxValue() {
        return 65534;
    }

    public SnapshotRestoreRequestEncoder chunkIdx(int value) {
        this.buffer.putShort(this.offset + 8, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        SnapshotRestoreRequestDecoder writer = new SnapshotRestoreRequestDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 10, 1);
        return writer.appendTo(builder);
    }
}

