/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker;

import io.zeebe.broker.Broker;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;

public class StandaloneBroker {
    private static String tempFolder;
    private static final CountDownLatch WAITING_LATCH;

    public static void main(String[] args) throws Exception {
        final Broker broker = args.length == 1 ? StandaloneBroker.startBrokerFromConfiguration(args) : StandaloneBroker.startDefaultBrokerInTempDirectory();
        Runtime.getRuntime().addShutdownHook(new Thread("Broker close Thread"){

            @Override
            public void run() {
                try {
                    if (broker != null) {
                        broker.close();
                    }
                }
                finally {
                    StandaloneBroker.deleteTempDirectory();
                }
            }
        });
        WAITING_LATCH.await();
    }

    private static Broker startBrokerFromConfiguration(String[] args) {
        String basePath = System.getProperty("basedir");
        if (basePath == null) {
            basePath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        }
        return new Broker(args[0], basePath, null);
    }

    private static Broker startDefaultBrokerInTempDirectory() {
        Loggers.SYSTEM_LOGGER.info("No configuration file specified. Using default configuration.");
        try {
            tempFolder = Files.createTempDirectory("zeebe", new FileAttribute[0]).toAbsolutePath().normalize().toString();
            BrokerCfg cfg = new BrokerCfg();
            return new Broker(cfg, tempFolder, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start broker", e);
        }
    }

    private static void deleteTempDirectory() {
        if (tempFolder != null) {
            try {
                FileUtil.deleteFolder((String)tempFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        WAITING_LATCH = new CountDownLatch(1);
    }
}

