/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.utils.net.Address;
import io.zeebe.gateway.Gateway;
import io.zeebe.gateway.impl.configuration.ClusterCfg;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.util.TomlConfigurationReader;
import java.io.IOException;
import java.nio.file.Paths;

public class StandaloneGateway {
    private final AtomixCluster atomixCluster;
    private final Gateway gateway;

    public StandaloneGateway(GatewayCfg gatewayCfg) {
        this.atomixCluster = this.createAtomixCluster(gatewayCfg.getCluster());
        this.gateway = new Gateway(gatewayCfg, this.atomixCluster);
    }

    private AtomixCluster createAtomixCluster(ClusterCfg clusterCfg) {
        AtomixCluster atomixCluster = AtomixCluster.builder().withMemberId(clusterCfg.getMemberId()).withAddress(Address.from((String)clusterCfg.getHost(), (int)clusterCfg.getPort())).withClusterId(clusterCfg.getClusterName()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(new Address[]{Address.from((String)clusterCfg.getContactPoint())}).build()).build();
        atomixCluster.start();
        return atomixCluster;
    }

    public void run() throws IOException, InterruptedException {
        this.gateway.listenAndServe();
        this.atomixCluster.stop();
    }

    public static void main(String[] args) throws Exception {
        GatewayCfg gatewayCfg = StandaloneGateway.initConfiguration(args);
        gatewayCfg.init();
        new StandaloneGateway(gatewayCfg).run();
    }

    private static GatewayCfg initConfiguration(String[] args) {
        if (args.length >= 1) {
            String configFileLocation = args[0];
            if (!Paths.get(configFileLocation, new String[0]).isAbsolute()) {
                configFileLocation = Paths.get(StandaloneGateway.getBasePath(), configFileLocation).toAbsolutePath().normalize().toString();
            }
            return (GatewayCfg)TomlConfigurationReader.read((String)configFileLocation, GatewayCfg.class);
        }
        return new GatewayCfg();
    }

    private static String getBasePath() {
        String basePath = System.getProperty("basedir");
        if (basePath == null) {
            basePath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        }
        return basePath;
    }
}

