/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import io.zeebe.msgpack.el.JsonCondition;
import java.util.Set;
import org.agrona.DirectBuffer;
import scala.collection.JavaConverters;

public final class CompiledJsonCondition {
    private final String expression;
    private final JsonCondition condition;
    private final boolean isValid;
    private final String errorMessage;

    private CompiledJsonCondition(String expression, JsonCondition condition, boolean isValid, String errorMessage) {
        this.expression = expression;
        this.condition = condition;
        this.isValid = isValid;
        this.errorMessage = errorMessage;
    }

    public static CompiledJsonCondition success(String expression, JsonCondition condition) {
        return new CompiledJsonCondition(expression, condition, true, null);
    }

    public static CompiledJsonCondition fail(String expression, String errorMessage) {
        return new CompiledJsonCondition(expression, null, false, errorMessage);
    }

    public String getExpression() {
        return this.expression;
    }

    public JsonCondition getCondition() {
        return this.condition;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Set<DirectBuffer> getVariableNames() {
        return JavaConverters.setAsJavaSet(this.condition.variableNames());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompiledJsonCondition [expression=");
        builder.append(this.expression);
        builder.append(", errorMessage=");
        builder.append(this.errorMessage);
        builder.append("]");
        return builder.toString();
    }
}

