/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import io.zeebe.msgpack.el.CompiledJsonCondition;
import io.zeebe.msgpack.el.JsonCondition;
import io.zeebe.msgpack.el.JsonConditionParser;
import io.zeebe.msgpack.el.JsonConditionValidator;
import io.zeebe.msgpack.el.JsonConditionWalker;
import io.zeebe.msgpack.el.JsonPath;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import scala.util.parsing.combinator.Parsers;

public class JsonConditionFactory {
    public static CompiledJsonCondition createCondition(String expression) {
        if (expression == null || expression.isEmpty()) {
            return CompiledJsonCondition.fail(expression, "expression is empty");
        }
        Parsers.ParseResult<JsonCondition> result = JsonConditionParser.parse(expression);
        if (result.successful()) {
            JsonCondition condition = (JsonCondition)result.get();
            String errorMessage = JsonConditionValidator.validate(condition);
            if (errorMessage == null) {
                JsonConditionFactory.indexJsonPathExpressions(condition);
                return CompiledJsonCondition.success(expression, condition);
            }
            return CompiledJsonCondition.fail(expression, errorMessage);
        }
        return CompiledJsonCondition.fail(expression, result.toString());
    }

    private static void indexJsonPathExpressions(JsonCondition condition) {
        ArrayList pathExpressions = new ArrayList();
        JsonConditionWalker.walk(condition, object -> {
            if (object instanceof JsonPath) {
                pathExpressions.add((JsonPath)object);
            }
        });
        AtomicInteger nextId = new AtomicInteger(1);
        pathExpressions.stream().collect(Collectors.groupingBy(JsonPath::jsonPath)).values().stream().filter(l -> l.size() > 1).forEach(l -> {
            int id = nextId.getAndIncrement();
            l.forEach(p -> p.id(id));
        });
    }
}

