/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import io.zeebe.msgpack.el.Comparison;
import io.zeebe.msgpack.el.CompiledJsonCondition;
import io.zeebe.msgpack.el.Conjunction;
import io.zeebe.msgpack.el.Disjunction;
import io.zeebe.msgpack.el.Equal;
import io.zeebe.msgpack.el.GreaterOrEqual;
import io.zeebe.msgpack.el.GreaterThan;
import io.zeebe.msgpack.el.JsonCondition;
import io.zeebe.msgpack.el.JsonConditionException;
import io.zeebe.msgpack.el.JsonConstant;
import io.zeebe.msgpack.el.JsonObject;
import io.zeebe.msgpack.el.JsonPath;
import io.zeebe.msgpack.el.JsonPathCache;
import io.zeebe.msgpack.el.LessOrEqual;
import io.zeebe.msgpack.el.LessThan;
import io.zeebe.msgpack.el.NotEqual;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.query.MsgPackQueryExecutor;
import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class JsonConditionInterpreter {
    private final MsgPackQueryExecutor visitor = new MsgPackQueryExecutor();
    private final MsgPackTraverser traverser = new MsgPackTraverser();
    private final MsgPackReader msgPackReader1 = new MsgPackReader();
    private final MsgPackReader msgPackReader2 = new MsgPackReader();
    private final JsonPathCache cache = new JsonPathCache();

    public boolean eval(CompiledJsonCondition condition, DirectBuffer json) {
        this.cache.wrap(json);
        try {
            return this.evalCondition(condition.getCondition(), json);
        }
        catch (Exception e) {
            throw new JsonConditionException(condition, e);
        }
    }

    private boolean evalCondition(JsonCondition condition, DirectBuffer json) {
        boolean isFulFilled;
        if (condition instanceof Comparison) {
            isFulFilled = this.evalComparison((Comparison)((Object)condition), json);
        } else if (condition instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)condition;
            isFulFilled = this.evalCondition(disjunction.x(), json) || this.evalCondition(disjunction.y(), json);
        } else if (condition instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)condition;
            isFulFilled = this.evalCondition(conjunction.x(), json) && this.evalCondition(conjunction.y(), json);
        } else {
            throw new RuntimeException(String.format("Illegal condition: %s", condition));
        }
        return isFulFilled;
    }

    private boolean evalComparison(Comparison comparison, DirectBuffer json) {
        MsgPackToken x = this.getToken(comparison.x(), json, this.msgPackReader1);
        MsgPackToken y = this.getToken(comparison.y(), json, this.msgPackReader2);
        if (comparison instanceof Equal) {
            return this.equals(x, y);
        }
        if (comparison instanceof NotEqual) {
            return this.notEquals(x, y);
        }
        if (comparison instanceof LessThan) {
            return this.lessThan(x, y);
        }
        if (comparison instanceof LessOrEqual) {
            return this.lessThanOrEqual(x, y);
        }
        if (comparison instanceof GreaterThan) {
            return this.greaterThan(x, y);
        }
        if (comparison instanceof GreaterOrEqual) {
            return this.greaterThanOrEqual(x, y);
        }
        throw new RuntimeException(String.format("Illegal comparison: %s", comparison));
    }

    private MsgPackToken getToken(JsonObject value, DirectBuffer json, MsgPackReader msgPackReader) {
        if (value instanceof JsonConstant) {
            JsonConstant constant = (JsonConstant)((Object)value);
            return constant.token();
        }
        if (value instanceof JsonPath) {
            JsonPath jsonPath = (JsonPath)value;
            return this.getPathResult(jsonPath, json, msgPackReader);
        }
        throw new RuntimeException(String.format("Illegal value: %s", value));
    }

    private MsgPackToken getPathResult(JsonPath path, DirectBuffer json, MsgPackReader msgPackReader) {
        DirectBuffer resultBuffer;
        int pathId = path.id();
        boolean cachable = pathId > 0;
        DirectBuffer directBuffer = resultBuffer = cachable ? this.cache.get(pathId) : null;
        if (resultBuffer != null) {
            if (resultBuffer.capacity() == 0) {
                return MsgPackToken.NIL;
            }
            msgPackReader.wrap(resultBuffer, 0, resultBuffer.capacity());
        } else {
            if (!this.readQueryResult(path.query(), json)) {
                if (cachable) {
                    this.cache.put(pathId, 0, 0);
                }
                return MsgPackToken.NIL;
            }
            int offset = this.visitor.currentResultPosition();
            int length = this.visitor.currentResultLength();
            msgPackReader.wrap(json, offset, length);
            if (cachable) {
                this.cache.put(pathId, offset, length);
            }
        }
        return msgPackReader.readToken();
    }

    private boolean readQueryResult(JsonPathQuery query, DirectBuffer json) {
        this.visitor.init(query.getFilters(), query.getFilterInstances());
        this.traverser.wrap(json, 0, json.capacity());
        this.traverser.traverse((MsgPackTokenVisitor)this.visitor);
        if (this.visitor.numResults() == 0) {
            return false;
        }
        if (this.visitor.numResults() > 1) {
            throw new JsonConditionException(String.format("JSON path '%s' has more than one result.", BufferUtil.bufferAsString((DirectBuffer)query.getExpression())));
        }
        this.visitor.moveToResult(0);
        return true;
    }

    private boolean equals(MsgPackToken x, MsgPackToken y) {
        if (x.getType() == MsgPackType.NIL || y.getType() == MsgPackType.NIL) {
            return x.getType() == y.getType();
        }
        this.ensureSameType(x, y);
        switch (x.getType()) {
            case STRING: {
                return BufferUtil.equals((DirectBuffer)x.getValueBuffer(), (DirectBuffer)y.getValueBuffer());
            }
            case BOOLEAN: {
                return x.getBooleanValue() == y.getBooleanValue();
            }
            case INTEGER: {
                return x.getIntegerValue() == y.getIntegerValue();
            }
            case FLOAT: {
                return x.getFloatValue() == y.getFloatValue();
            }
        }
        throw new JsonConditionException(String.format("Cannot compare value of type: %s", x.getType()));
    }

    private boolean notEquals(MsgPackToken x, MsgPackToken y) {
        return !this.equals(x, y);
    }

    private boolean lessThan(MsgPackToken x, MsgPackToken y) {
        this.ensureSameType(x, y);
        this.ensureNumber(x);
        if (x.getType() == MsgPackType.INTEGER) {
            return x.getIntegerValue() < y.getIntegerValue();
        }
        return x.getFloatValue() < y.getFloatValue();
    }

    private boolean lessThanOrEqual(MsgPackToken x, MsgPackToken y) {
        this.ensureSameType(x, y);
        this.ensureNumber(x);
        if (x.getType() == MsgPackType.INTEGER) {
            return x.getIntegerValue() <= y.getIntegerValue();
        }
        return x.getFloatValue() <= y.getFloatValue();
    }

    private boolean greaterThan(MsgPackToken x, MsgPackToken y) {
        this.ensureSameType(x, y);
        this.ensureNumber(x);
        if (x.getType() == MsgPackType.INTEGER) {
            return x.getIntegerValue() > y.getIntegerValue();
        }
        return x.getFloatValue() > y.getFloatValue();
    }

    private boolean greaterThanOrEqual(MsgPackToken x, MsgPackToken y) {
        this.ensureSameType(x, y);
        this.ensureNumber(x);
        if (x.getType() == MsgPackType.INTEGER) {
            return x.getIntegerValue() >= y.getIntegerValue();
        }
        return x.getFloatValue() >= y.getFloatValue();
    }

    private void ensureSameType(MsgPackToken x, MsgPackToken y) {
        if (x.getType() == MsgPackType.INTEGER && y.getType() == MsgPackType.FLOAT) {
            x.setType(MsgPackType.FLOAT);
            x.setValue((double)x.getIntegerValue());
        } else if (x.getType() == MsgPackType.FLOAT && y.getType() == MsgPackType.INTEGER) {
            y.setType(MsgPackType.FLOAT);
            y.setValue((double)y.getIntegerValue());
        } else if (x.getType() != y.getType()) {
            throw new JsonConditionException(String.format("Cannot compare values of different types: %s and %s", x.getType(), y.getType()));
        }
    }

    private void ensureNumber(MsgPackToken x) {
        if (x.getType() != MsgPackType.INTEGER && x.getType() != MsgPackType.FLOAT) {
            throw new JsonConditionException(String.format("Cannot compare values. Expected number but found: %s", x.getType()));
        }
    }
}

