/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import io.zeebe.msgpack.el.JsonCondition;
import io.zeebe.msgpack.el.JsonConditionWalker;
import io.zeebe.msgpack.el.JsonPath;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import java.util.ArrayList;
import java.util.List;

public class JsonConditionValidator {
    public static String validate(JsonCondition condition) {
        ArrayList<String> errors = new ArrayList<String>();
        JsonConditionValidator.validateCondition(condition, errors);
        if (errors.isEmpty()) {
            return null;
        }
        return JsonConditionValidator.formatErrorMessage(errors);
    }

    private static void validateCondition(JsonCondition condition, List<String> errors) {
        JsonConditionWalker.walk(condition, object -> {
            JsonPath path;
            JsonPathQuery query;
            if (object instanceof JsonPath && !(query = (path = (JsonPath)object).query()).isValid()) {
                errors.add(query.getErrorReason());
            }
        });
    }

    private static String formatErrorMessage(List<String> errors) {
        StringBuilder builder = new StringBuilder();
        builder.append(errors.get(0));
        for (int i = 1; i < errors.size(); ++i) {
            String error = errors.get(i);
            builder.append("\n");
            builder.append(error);
        }
        return builder.toString();
    }
}

