/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import io.zeebe.msgpack.el.Comparison;
import io.zeebe.msgpack.el.JsonCondition;
import io.zeebe.msgpack.el.JsonConditionVisitor;
import io.zeebe.msgpack.el.Operator;

public class JsonConditionWalker {
    public static void walk(JsonCondition condition, JsonConditionVisitor visitor) {
        if (condition instanceof Comparison) {
            JsonConditionWalker.visitComparison((Comparison)((Object)condition), visitor);
        } else if (condition instanceof Operator) {
            Operator operator = (Operator)((Object)condition);
            JsonConditionWalker.walk(operator.x(), visitor);
            JsonConditionWalker.walk(operator.y(), visitor);
        } else {
            throw new RuntimeException(String.format("Illegal condition: %s", condition));
        }
    }

    private static void visitComparison(Comparison comparison, JsonConditionVisitor visitor) {
        visitor.visitObject(comparison.x());
        visitor.visitObject(comparison.y());
    }
}

