/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.el;

import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JsonPathCache {
    private static final int INITIAL_CAPACITY = 12;
    private int size = 0;
    private int capacity = 12;
    private int[] keys = new int[12];
    private int[] offsets = new int[12];
    private int[] lengths = new int[12];
    private final DirectBuffer valueBuffer = new UnsafeBuffer(0L, 0);
    private final DirectBuffer bufferView = new UnsafeBuffer(0L, 0);

    public void wrap(DirectBuffer buffer) {
        this.valueBuffer.wrap(buffer);
        this.size = 0;
    }

    public DirectBuffer get(int key) {
        for (int k = 0; k < this.size; ++k) {
            if (key != this.keys[k]) continue;
            int offset = this.offsets[k];
            int length = this.lengths[k];
            this.bufferView.wrap(this.valueBuffer, offset, length);
            return this.bufferView;
        }
        return null;
    }

    public void put(int key, int offset, int length) {
        if (this.size > this.capacity) {
            this.capacity *= 2;
            this.keys = Arrays.copyOf(this.keys, this.capacity);
            this.offsets = Arrays.copyOf(this.offsets, this.capacity);
            this.lengths = Arrays.copyOf(this.lengths, this.capacity);
        }
        this.keys[this.size] = key;
        this.offsets[this.size] = offset;
        this.lengths[this.size] = length;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        this.capacity = 12;
        this.keys = new int[12];
        this.offsets = new int[12];
        this.lengths = new int[12];
    }
}

