/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.barrier.impl;

import com.google.common.base.Throwables;
import io.atomix.core.barrier.AsyncDistributedCyclicBarrier;
import io.atomix.core.barrier.DistributedCyclicBarrier;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingDistributedCyclicBarrier
extends Synchronous<AsyncDistributedCyclicBarrier>
implements DistributedCyclicBarrier {
    private final AsyncDistributedCyclicBarrier asyncBarrier;
    private final long operationTimeoutMillis;

    public BlockingDistributedCyclicBarrier(AsyncDistributedCyclicBarrier asyncBarrier, long operationTimeoutMillis) {
        super((AsyncPrimitive)asyncBarrier);
        this.asyncBarrier = asyncBarrier;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int await() {
        return this.complete(this.asyncBarrier.await());
    }

    @Override
    public int await(Duration timeout) {
        return this.complete(this.asyncBarrier.await(timeout));
    }

    @Override
    public int getNumberWaiting() {
        return this.complete(this.asyncBarrier.getNumberWaiting());
    }

    @Override
    public int getParties() {
        return this.complete(this.asyncBarrier.getParties());
    }

    @Override
    public boolean isBroken() {
        return this.complete(this.asyncBarrier.isBroken());
    }

    @Override
    public void reset() {
        this.complete(this.asyncBarrier.reset());
    }

    @Override
    public AsyncDistributedCyclicBarrier async() {
        return this.asyncBarrier;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

