/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.TranscodingIterator;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TranscodingAsyncDistributedCollection<E1, E2>
extends DelegatingAsyncPrimitive
implements AsyncDistributedCollection<E1> {
    private final AsyncDistributedCollection<E2> backingCollection;
    private final Function<E1, E2> elementEncoder;
    private final Function<E2, E1> elementDecoder;
    private final Map<CollectionEventListener<E1>, InternalCollectionEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncDistributedCollection(AsyncDistributedCollection<E2> backingCollection, Function<E1, E2> elementEncoder, Function<E2, E1> elementDecoder) {
        super(backingCollection);
        this.backingCollection = backingCollection;
        this.elementEncoder = k -> k == null ? null : elementEncoder.apply(k);
        this.elementDecoder = k -> k == null ? null : elementDecoder.apply(k);
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.backingCollection.size();
    }

    @Override
    public CompletableFuture<Boolean> add(E1 element) {
        return this.backingCollection.add(this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<Boolean> remove(E1 element) {
        return this.backingCollection.remove(this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.backingCollection.isEmpty();
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.backingCollection.clear();
    }

    @Override
    public CompletableFuture<Boolean> contains(E1 element) {
        return this.backingCollection.contains(this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E1> c) {
        return this.backingCollection.addAll(c.stream().map(this.elementEncoder).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E1> c) {
        return this.backingCollection.containsAll(c.stream().map(this.elementEncoder).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E1> c) {
        return this.backingCollection.retainAll(c.stream().map(this.elementEncoder).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E1> c) {
        return this.backingCollection.removeAll(c.stream().map(this.elementEncoder).collect(Collectors.toList()));
    }

    @Override
    public AsyncIterator<E1> iterator() {
        return new TranscodingIterator<E1, E2>(this.backingCollection.iterator(), this.elementDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(CollectionEventListener<E1> listener, Executor executor) {
        Map<CollectionEventListener<E1>, InternalCollectionEventListener> map = this.listeners;
        synchronized (map) {
            InternalCollectionEventListener collectionListener = this.listeners.computeIfAbsent(listener, k -> new InternalCollectionEventListener(listener));
            return this.backingCollection.addListener(collectionListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(CollectionEventListener<E1> listener) {
        Map<CollectionEventListener<E1>, InternalCollectionEventListener> map = this.listeners;
        synchronized (map) {
            InternalCollectionEventListener collectionListener = this.listeners.remove(listener);
            if (collectionListener != null) {
                return this.backingCollection.removeListener(collectionListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public DistributedCollection<E1> sync(Duration operationTimeout) {
        return new BlockingDistributedCollection(this, operationTimeout.toMillis());
    }

    private class InternalCollectionEventListener
    implements CollectionEventListener<E2> {
        private final CollectionEventListener<E1> listener;

        InternalCollectionEventListener(CollectionEventListener<E1> listener) {
            this.listener = listener;
        }

        public void event(CollectionEvent<E2> event) {
            this.listener.event((Event)new CollectionEvent((CollectionEvent.Type)event.type(), TranscodingAsyncDistributedCollection.this.elementDecoder.apply(event.element())));
        }
    }
}

