/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import io.atomix.core.counter.AsyncDistributedCounter;
import io.atomix.core.counter.DistributedCounter;
import io.atomix.core.counter.DistributedCounterType;
import io.atomix.core.counter.impl.BlockingDistributedCounter;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.counter.CounterDelegate;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class GossipDistributedCounter
implements AsyncDistributedCounter {
    private final String name;
    private final GossipProtocol protocol;
    private final CounterDelegate counter;

    public GossipDistributedCounter(String name, GossipProtocol protocol, CounterDelegate counter) {
        this.name = name;
        this.protocol = protocol;
        this.counter = counter;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType type() {
        return DistributedCounterType.instance();
    }

    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletableFuture<Long> incrementAndGet() {
        return CompletableFuture.completedFuture(this.counter.incrementAndGet());
    }

    @Override
    public CompletableFuture<Long> decrementAndGet() {
        return CompletableFuture.completedFuture(this.counter.decrementAndGet());
    }

    @Override
    public CompletableFuture<Long> getAndIncrement() {
        return CompletableFuture.completedFuture(this.counter.getAndIncrement());
    }

    @Override
    public CompletableFuture<Long> getAndDecrement() {
        return CompletableFuture.completedFuture(this.counter.getAndDecrement());
    }

    @Override
    public CompletableFuture<Long> getAndAdd(long delta) {
        return CompletableFuture.completedFuture(this.counter.getAndAdd(delta));
    }

    @Override
    public CompletableFuture<Long> addAndGet(long delta) {
        return CompletableFuture.completedFuture(this.counter.addAndGet(delta));
    }

    @Override
    public CompletableFuture<Long> get() {
        return CompletableFuture.completedFuture(this.counter.get());
    }

    @Override
    public DistributedCounter sync(Duration operationTimeout) {
        return new BlockingDistributedCounter(this, operationTimeout.toMillis());
    }

    public CompletableFuture<Void> close() {
        this.counter.close();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete() {
        return CompletableFuture.completedFuture(null);
    }
}

