/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.atomix.core.election.Leader;
import io.atomix.core.election.LeaderElectionType;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.impl.LeaderElectionClient;
import io.atomix.core.election.impl.LeaderElectionService;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.misc.ArraySizeHashPrinter;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class DefaultLeaderElectionService
extends AbstractPrimitiveService<LeaderElectionClient>
implements LeaderElectionService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(LeaderElectionType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{Registration.class}).register(new Class[]{new LinkedHashMap().keySet().getClass()}).build());
    private Registration leader;
    private long term;
    private long termStartTime;
    private List<Registration> registrations = new LinkedList<Registration>();
    private AtomicLong termCounter = new AtomicLong();
    private Set<SessionId> listeners = new LinkedHashSet<SessionId>();

    public DefaultLeaderElectionService() {
        super(LeaderElectionType.instance(), LeaderElectionClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput writer) {
        writer.writeLong(this.termCounter.get());
        writer.writeObject((Object)this.leader);
        writer.writeLong(this.term);
        writer.writeLong(this.termStartTime);
        writer.writeObject(this.registrations);
        writer.writeObject(this.listeners);
        this.getLogger().debug("Took state machine snapshot");
    }

    public void restore(BackupInput reader) {
        this.termCounter.set(reader.readLong());
        this.leader = (Registration)reader.readObject();
        this.term = reader.readLong();
        this.termStartTime = reader.readLong();
        this.registrations = (List)reader.readObject();
        this.listeners = (Set)reader.readObject();
        this.getLogger().debug("Reinstated state machine from snapshot");
    }

    @Override
    public void listen() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unlisten() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    private void notifyLeadershipChange(Leadership<byte[]> oldLeadership, Leadership<byte[]> newLeadership) {
        this.listeners.forEach(id -> this.getSession((SessionId)id).accept(client -> client.onLeadershipChange(oldLeadership, newLeadership)));
    }

    @Override
    public Leadership<byte[]> run(byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership();
            Registration registration = new Registration(id, (Long)this.getCurrentSession().sessionId().id());
            this.addRegistration(registration);
            Leadership<byte[]> newLeadership = this.leadership();
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            return newLeadership;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void withdraw(byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership();
            this.cleanup(id);
            Leadership<byte[]> newLeadership = this.leadership();
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean anoint(byte[] id) {
        try {
            Leadership<byte[]> newLeadership;
            Leadership<byte[]> oldLeadership = this.leadership();
            Registration newLeader = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst().orElse(null);
            if (newLeader != null) {
                this.leader = newLeader;
                this.term = this.termCounter.incrementAndGet();
                this.termStartTime = this.getWallClock().getTime().unixTimestamp();
            }
            if (!Objects.equal(oldLeadership, newLeadership = this.leadership())) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            return this.leader != null && Arrays.equals(id, this.leader.id());
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean promote(byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership();
            boolean containsCandidate = oldLeadership.candidates().stream().anyMatch(a -> Arrays.equals(a, id));
            if (!containsCandidate) {
                return false;
            }
            Registration registration = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst().orElse(null);
            ArrayList updatedRegistrations = Lists.newArrayList();
            updatedRegistrations.add(registration);
            this.registrations.stream().filter(r -> !Arrays.equals(r.id(), id)).forEach(updatedRegistrations::add);
            this.registrations = updatedRegistrations;
            Leadership<byte[]> newLeadership = this.leadership();
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void evict(byte[] id) {
        try {
            Leadership<byte[]> newLeadership;
            Leadership<byte[]> oldLeadership = this.leadership();
            Optional<Registration> registration = this.registrations.stream().filter(r -> Arrays.equals(((Registration)r).id, id)).findFirst();
            if (registration.isPresent()) {
                List updatedRegistrations = this.registrations.stream().filter(r -> !Arrays.equals(r.id(), id)).collect(Collectors.toList());
                if (Arrays.equals(this.leader.id(), id)) {
                    if (!updatedRegistrations.isEmpty()) {
                        this.registrations = updatedRegistrations;
                        this.leader = (Registration)updatedRegistrations.get(0);
                        this.term = this.termCounter.incrementAndGet();
                        this.termStartTime = this.getWallClock().getTime().unixTimestamp();
                    } else {
                        this.registrations = updatedRegistrations;
                        this.leader = null;
                    }
                } else {
                    this.registrations = updatedRegistrations;
                }
            }
            if (!Objects.equal(oldLeadership, newLeadership = this.leadership())) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Leadership<byte[]> getLeadership() {
        try {
            return this.leadership();
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Leadership<byte[]> leadership() {
        return new Leadership<byte[]>(this.leader(), this.candidates());
    }

    private void onSessionEnd(Session session) {
        this.listeners.remove(session.sessionId());
        Leadership<byte[]> oldLeadership = this.leadership();
        this.cleanup(session);
        Leadership<byte[]> newLeadership = this.leadership();
        if (!Objects.equal(oldLeadership, newLeadership)) {
            this.notifyLeadershipChange(oldLeadership, newLeadership);
        }
    }

    protected void cleanup(byte[] id) {
        Optional<Registration> registration = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst();
        if (registration.isPresent()) {
            List updatedRegistrations = this.registrations.stream().filter(r -> !Arrays.equals(r.id(), id)).collect(Collectors.toList());
            if (Arrays.equals(this.leader.id(), id)) {
                if (!updatedRegistrations.isEmpty()) {
                    this.registrations = updatedRegistrations;
                    this.leader = (Registration)updatedRegistrations.get(0);
                    this.term = this.termCounter.incrementAndGet();
                    this.termStartTime = this.getWallClock().getTime().unixTimestamp();
                } else {
                    this.registrations = updatedRegistrations;
                    this.leader = null;
                }
            } else {
                this.registrations = updatedRegistrations;
            }
        }
    }

    protected void cleanup(Session session) {
        Optional<Registration> registration = this.registrations.stream().filter(r -> r.sessionId() == ((Long)session.sessionId().id()).longValue()).findFirst();
        if (registration.isPresent()) {
            List updatedRegistrations = this.registrations.stream().filter(r -> r.sessionId() != ((Long)session.sessionId().id()).longValue()).collect(Collectors.toList());
            if (this.leader.sessionId() == ((Long)session.sessionId().id()).longValue()) {
                if (!updatedRegistrations.isEmpty()) {
                    this.registrations = updatedRegistrations;
                    this.leader = (Registration)updatedRegistrations.get(0);
                    this.term = this.termCounter.incrementAndGet();
                    this.termStartTime = this.getWallClock().getTime().unixTimestamp();
                } else {
                    this.registrations = updatedRegistrations;
                    this.leader = null;
                }
            } else {
                this.registrations = updatedRegistrations;
            }
        }
    }

    protected Leader<byte[]> leader() {
        if (this.leader == null) {
            return null;
        }
        byte[] leaderId = this.leader.id();
        return new Leader<byte[]>(leaderId, this.term, this.termStartTime);
    }

    protected List<byte[]> candidates() {
        return this.registrations.stream().map(registration -> registration.id()).collect(Collectors.toList());
    }

    protected void addRegistration(Registration registration) {
        if (this.registrations.stream().noneMatch(r -> Arrays.equals(registration.id(), r.id()))) {
            LinkedList<Registration> updatedRegistrations = new LinkedList<Registration>(this.registrations);
            updatedRegistrations.add(registration);
            boolean newLeader = this.leader == null;
            this.registrations = updatedRegistrations;
            if (newLeader) {
                this.leader = registration;
                this.term = this.termCounter.incrementAndGet();
                this.termStartTime = this.getWallClock().getTime().unixTimestamp();
            }
        }
    }

    public void onExpire(Session session) {
        this.onSessionEnd(session);
    }

    public void onClose(Session session) {
        this.onSessionEnd(session);
    }

    private static class Registration {
        private final byte[] id;
        private final long sessionId;

        protected Registration(byte[] id, long sessionId) {
            this.id = id;
            this.sessionId = sessionId;
        }

        protected byte[] id() {
            return this.id;
        }

        protected long sessionId() {
            return this.sessionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)ArraySizeHashPrinter.of((byte[])this.id)).add("sessionId", this.sessionId).toString();
        }
    }
}

