/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.election.Leader;
import io.atomix.core.election.LeaderElectorType;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.impl.LeaderElectorClient;
import io.atomix.core.election.impl.LeaderElectorService;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.misc.ArraySizeHashPrinter;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DefaultLeaderElectorService
extends AbstractPrimitiveService<LeaderElectorClient>
implements LeaderElectorService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(LeaderElectorType.instance().namespace()).register(new Class[]{ElectionState.class}).register(new Class[]{Registration.class}).register(new Class[]{new LinkedHashMap().keySet().getClass()}).register(new Class[]{SessionId.class}).build());
    private Map<String, AtomicLong> termCounters = new HashMap<String, AtomicLong>();
    private Map<String, ElectionState> elections = new HashMap<String, ElectionState>();
    private Set<SessionId> listeners = new LinkedHashSet<SessionId>();

    public DefaultLeaderElectorService() {
        super(LeaderElectorType.instance(), LeaderElectorClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput writer) {
        writer.writeObject(this.listeners);
        writer.writeObject(this.termCounters);
        writer.writeObject(this.elections);
        this.getLogger().debug("Took state machine snapshot");
    }

    public void restore(BackupInput reader) {
        this.listeners = (Set)reader.readObject();
        this.termCounters = (Map)reader.readObject();
        this.elections = (Map)reader.readObject();
        this.elections.values().forEach(e -> {
            e.elections = this.elections;
        });
        this.getLogger().debug("Reinstated state machine from snapshot");
    }

    private void notifyLeadershipChange(String topic, Leadership<byte[]> previousLeadership, Leadership<byte[]> newLeadership) {
        this.listeners.forEach(id -> this.getSession((SessionId)id).accept(client -> client.onLeadershipChange(topic, previousLeadership, newLeadership)));
    }

    @Override
    public void listen() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unlisten() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    @Override
    public Leadership<byte[]> run(String topic, byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership(topic);
            Registration registration = new Registration(id, (Long)this.getCurrentSession().sessionId().id());
            this.elections.compute(topic, (k, v) -> {
                if (v == null) {
                    return new ElectionState(registration, this.termCounter(topic)::incrementAndGet, this.elections);
                }
                if (!v.isDuplicate(registration)) {
                    return new ElectionState((ElectionState)v).addRegistration(topic, registration, this.termCounter(topic)::incrementAndGet);
                }
                return v;
            });
            Leadership<byte[]> newLeadership = this.leadership(topic);
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(topic, oldLeadership, newLeadership);
            }
            return newLeadership;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void withdraw(String topic, byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership(topic);
            this.elections.computeIfPresent(topic, (k, v) -> v.cleanup(topic, this.getCurrentSession(), this.termCounter(topic)::incrementAndGet));
            Leadership<byte[]> newLeadership = this.leadership(topic);
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(topic, oldLeadership, newLeadership);
            }
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean anoint(String topic, byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership(topic);
            ElectionState electionState = this.elections.computeIfPresent(topic, (k, v) -> v.transferLeadership(id, this.termCounter(topic)));
            Leadership<byte[]> newLeadership = this.leadership(topic);
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(topic, oldLeadership, newLeadership);
            }
            return electionState != null && electionState.leader() != null && Arrays.equals(id, electionState.leader().id());
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean promote(String topic, byte[] id) {
        try {
            Leadership<byte[]> oldLeadership = this.leadership(topic);
            if (oldLeadership == null || oldLeadership.candidates().stream().noneMatch(candidate -> Arrays.equals(candidate, id))) {
                return false;
            }
            this.elections.computeIfPresent(topic, (k, v) -> v.promote(id));
            Leadership<byte[]> newLeadership = this.leadership(topic);
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange(topic, oldLeadership, newLeadership);
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void evict(byte[] id) {
        try {
            ArrayList changes = Lists.newArrayList();
            Set topics = Maps.filterValues(this.elections, e -> e.candidates().stream().anyMatch(candidate -> Arrays.equals(candidate, id))).keySet();
            topics.forEach(topic -> {
                Leadership<byte[]> oldLeadership = this.leadership((String)topic);
                this.elections.compute((String)topic, (k, v) -> v.evict(id, this.termCounter((String)topic)::incrementAndGet));
                Leadership<byte[]> newLeadership = this.leadership((String)topic);
                if (!Objects.equal(oldLeadership, newLeadership)) {
                    this.notifyLeadershipChange((String)topic, oldLeadership, newLeadership);
                }
            });
        }
        catch (Exception e2) {
            this.getLogger().error("State machine operation failed", (Throwable)e2);
            Throwables.throwIfUnchecked((Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Leadership<byte[]> getLeadership(String topic) {
        try {
            return this.leadership(topic);
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Leadership<byte[]>> getLeaderships() {
        HashMap<String, Leadership<byte[]>> result = new HashMap<String, Leadership<byte[]>>();
        try {
            result.putAll(Maps.transformEntries(this.elections, (k, v) -> this.leadership((String)k)));
            return result;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Leadership<byte[]> leadership(String topic) {
        return new Leadership<byte[]>(this.leader(topic), this.candidates(topic));
    }

    private Leader<byte[]> leader(String topic) {
        ElectionState electionState = this.elections.get(topic);
        return electionState == null ? null : electionState.leader();
    }

    private List<byte[]> candidates(String topic) {
        ElectionState electionState = this.elections.get(topic);
        return electionState == null ? new LinkedList() : electionState.candidates();
    }

    private void onSessionEnd(Session session) {
        this.listeners.remove(session.sessionId());
        Set<String> topics = this.elections.keySet();
        topics.forEach(topic -> {
            Leadership<byte[]> oldLeadership = this.leadership((String)topic);
            this.elections.compute((String)topic, (k, v) -> v.cleanup((String)topic, session, this.termCounter((String)topic)::incrementAndGet));
            Leadership<byte[]> newLeadership = this.leadership((String)topic);
            if (!Objects.equal(oldLeadership, newLeadership)) {
                this.notifyLeadershipChange((String)topic, oldLeadership, newLeadership);
            }
        });
    }

    public void onExpire(Session session) {
        this.onSessionEnd(session);
    }

    public void onClose(Session session) {
        this.onSessionEnd(session);
    }

    private AtomicLong termCounter(String topic) {
        return this.termCounters.computeIfAbsent(topic, k -> new AtomicLong(0L));
    }

    private class ElectionState {
        final Registration leader;
        final long term;
        final long termStartTime;
        final List<Registration> registrations;
        transient Map<String, ElectionState> elections;

        ElectionState(Registration registration, Supplier<Long> termCounter, Map<String, ElectionState> elections) {
            this.registrations = Arrays.asList(registration);
            this.term = termCounter.get();
            this.termStartTime = System.currentTimeMillis();
            this.leader = registration;
            this.elections = elections;
        }

        ElectionState(ElectionState other) {
            this.registrations = Lists.newArrayList(other.registrations);
            this.leader = other.leader;
            this.term = other.term;
            this.termStartTime = other.termStartTime;
            this.elections = other.elections;
        }

        ElectionState(List<Registration> registrations, Registration leader, long term, long termStartTime, Map<String, ElectionState> elections) {
            this.registrations = Lists.newArrayList(registrations);
            this.leader = leader;
            this.term = term;
            this.termStartTime = termStartTime;
            this.elections = elections;
        }

        private void sortRegistrations(String topic, List<Registration> registrations) {
            registrations.sort((a, b) -> ComparisonChain.start().compare(this.countLeaders(topic, (Registration)a), this.countLeaders(topic, (Registration)b)).compare(((Registration)a).sessionId, ((Registration)b).sessionId).result());
        }

        private long countLeaders(String topic, Registration registration) {
            return this.elections.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(topic)).filter(entry -> ((ElectionState)entry.getValue()).leader != null).filter(entry -> {
                byte[] leaderId = ((ElectionState)entry.getValue()).leader().id();
                List sessionCandidates = ((ElectionState)entry.getValue()).registrations.stream().filter(r -> ((Registration)r).sessionId == registration.sessionId).map(r -> ((Registration)r).id).collect(Collectors.toList());
                return sessionCandidates.stream().anyMatch(candidate -> Arrays.equals(candidate, leaderId));
            }).count();
        }

        public ElectionState cleanup(String topic, Session session, Supplier<Long> termCounter) {
            Optional<Registration> registration = this.registrations.stream().filter(r -> r.sessionId() == ((Long)session.sessionId().id()).longValue()).findFirst();
            if (registration.isPresent()) {
                List<Registration> updatedRegistrations = this.registrations.stream().filter(r -> r.sessionId() != ((Long)session.sessionId().id()).longValue()).collect(Collectors.toList());
                if (this.leader.sessionId() == ((Long)session.sessionId().id()).longValue()) {
                    if (!updatedRegistrations.isEmpty()) {
                        return new ElectionState(updatedRegistrations, (Registration)updatedRegistrations.get(0), termCounter.get(), System.currentTimeMillis(), this.elections);
                    }
                    return new ElectionState(updatedRegistrations, null, this.term, this.termStartTime, this.elections);
                }
                return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime, this.elections);
            }
            return this;
        }

        public ElectionState evict(byte[] id, Supplier<Long> termCounter) {
            Optional<Registration> registration = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst();
            if (registration.isPresent()) {
                List<Registration> updatedRegistrations = this.registrations.stream().filter(r -> !Arrays.equals(r.id(), id)).collect(Collectors.toList());
                if (Arrays.equals(this.leader.id(), id)) {
                    if (!updatedRegistrations.isEmpty()) {
                        return new ElectionState(updatedRegistrations, (Registration)updatedRegistrations.get(0), termCounter.get(), System.currentTimeMillis(), this.elections);
                    }
                    return new ElectionState(updatedRegistrations, null, this.term, this.termStartTime, this.elections);
                }
                return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime, this.elections);
            }
            return this;
        }

        public boolean isDuplicate(Registration registration) {
            return this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId());
        }

        public Leader<byte[]> leader() {
            if (this.leader == null) {
                return null;
            }
            byte[] leaderId = this.leader.id();
            return new Leader<byte[]>(leaderId, this.term, this.termStartTime);
        }

        public List<byte[]> candidates() {
            return this.registrations.stream().map(registration -> registration.id()).collect(Collectors.toList());
        }

        public ElectionState addRegistration(String topic, Registration registration, Supplier<Long> termCounter) {
            if (!this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId())) {
                LinkedList<Registration> updatedRegistrations = new LinkedList<Registration>(this.registrations);
                updatedRegistrations.add(registration);
                Registration firstRegistration = (Registration)updatedRegistrations.get(0);
                Registration leader = this.leader;
                long term = this.term;
                long termStartTime = this.termStartTime;
                if (leader == null || !leader.equals(firstRegistration)) {
                    leader = firstRegistration;
                    term = termCounter.get();
                    termStartTime = System.currentTimeMillis();
                }
                return new ElectionState(updatedRegistrations, leader, term, termStartTime, this.elections);
            }
            return this;
        }

        public ElectionState transferLeadership(byte[] id, AtomicLong termCounter) {
            Registration newLeader = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst().orElse(null);
            if (newLeader != null) {
                return new ElectionState(this.registrations, newLeader, termCounter.incrementAndGet(), System.currentTimeMillis(), this.elections);
            }
            return this;
        }

        public ElectionState promote(byte[] id) {
            Registration registration = this.registrations.stream().filter(r -> Arrays.equals(r.id(), id)).findFirst().orElse(null);
            ArrayList updatedRegistrations = Lists.newArrayList();
            updatedRegistrations.add(registration);
            this.registrations.stream().filter(r -> !Arrays.equals(r.id(), id)).forEach(updatedRegistrations::add);
            return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime, this.elections);
        }
    }

    private static class Registration {
        private final byte[] id;
        private final long sessionId;

        Registration(byte[] id, long sessionId) {
            this.id = id;
            this.sessionId = sessionId;
        }

        public byte[] id() {
            return this.id;
        }

        public long sessionId() {
            return this.sessionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)ArraySizeHashPrinter.of((byte[])this.id)).add("sessionId", this.sessionId).toString();
        }
    }
}

