/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.collect.Sets;
import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.core.election.impl.BlockingLeaderElection;
import io.atomix.core.election.impl.LeaderElectionClient;
import io.atomix.core.election.impl.LeaderElectionService;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class LeaderElectionProxy
extends AbstractAsyncPrimitive<AsyncLeaderElection<byte[]>, LeaderElectionService>
implements AsyncLeaderElection<byte[]>,
LeaderElectionClient {
    private final Set<LeadershipEventListener<byte[]>> leadershipChangeListeners = Sets.newCopyOnWriteArraySet();

    public LeaderElectionProxy(ProxyClient<LeaderElectionService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public void onLeadershipChange(Leadership<byte[]> oldLeadership, Leadership<byte[]> newLeadership) {
        this.leadershipChangeListeners.forEach(l -> l.event((Event)new LeadershipEvent(LeadershipEvent.Type.CHANGE, this.name(), oldLeadership, newLeadership)));
    }

    @Override
    public CompletableFuture<Leadership<byte[]>> run(byte[] id) {
        return this.getProxyClient().applyBy(this.name(), service -> service.run(id));
    }

    @Override
    public CompletableFuture<Void> withdraw(byte[] id) {
        return this.getProxyClient().acceptBy(this.name(), service -> service.withdraw(id));
    }

    @Override
    public CompletableFuture<Boolean> anoint(byte[] id) {
        return this.getProxyClient().applyBy(this.name(), service -> service.anoint(id));
    }

    @Override
    public CompletableFuture<Boolean> promote(byte[] id) {
        return this.getProxyClient().applyBy(this.name(), service -> service.promote(id));
    }

    @Override
    public CompletableFuture<Void> evict(byte[] id) {
        return this.getProxyClient().acceptBy(this.name(), service -> service.evict(id));
    }

    @Override
    public CompletableFuture<Leadership<byte[]>> getLeadership() {
        return this.getProxyClient().applyBy(this.name(), service -> service.getLeadership());
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(LeadershipEventListener<byte[]> listener) {
        if (this.leadershipChangeListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.listen()).thenRun(() -> this.leadershipChangeListeners.add(listener));
        }
        this.leadershipChangeListeners.add(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(LeadershipEventListener<byte[]> listener) {
        if (this.leadershipChangeListeners.remove(listener) && this.leadershipChangeListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.leadershipChangeListeners.isEmpty();
    }

    public CompletableFuture<AsyncLeaderElection<byte[]>> connect() {
        return ((CompletableFuture)((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenRun(() -> this.getProxyClient().getPartitions().forEach(partition -> partition.addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                partition.accept(service -> service.listen());
            }
        })))).thenApply(v -> this);
    }

    @Override
    public LeaderElection<byte[]> sync(Duration operationTimeout) {
        return new BlockingLeaderElection<byte[]>(this, operationTimeout.toMillis());
    }
}

