/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.core.election.AsyncLeaderElector;
import io.atomix.core.election.LeaderElector;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.core.election.impl.BlockingLeaderElector;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncLeaderElector<V1, V2>
extends DelegatingAsyncPrimitive
implements AsyncLeaderElector<V1> {
    private final AsyncLeaderElector<V2> backingElector;
    private final Function<V1, V2> valueEncoder;
    private final Function<V2, V1> valueDecoder;
    private final Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncLeaderElector(AsyncLeaderElector<V2> backingElector, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingElector);
        this.backingElector = backingElector;
        this.valueEncoder = valueEncoder;
        this.valueDecoder = valueDecoder;
    }

    @Override
    public CompletableFuture<Leadership<V1>> run(String topic, V1 identifier) {
        return this.backingElector.run(topic, this.valueEncoder.apply(identifier)).thenApply(leadership -> leadership.map(this.valueDecoder));
    }

    @Override
    public CompletableFuture<Void> withdraw(String topic, V1 identifier) {
        return this.backingElector.withdraw(topic, this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Boolean> anoint(String topic, V1 identifier) {
        return this.backingElector.anoint(topic, this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Void> evict(V1 identifier) {
        return this.backingElector.evict(this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Boolean> promote(String topic, V1 identifier) {
        return this.backingElector.promote(topic, this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Leadership<V1>> getLeadership(String topic) {
        return this.backingElector.getLeadership(topic).thenApply(leadership -> leadership.map(this.valueDecoder));
    }

    @Override
    public CompletableFuture<Map<String, Leadership<V1>>> getLeaderships() {
        return this.backingElector.getLeaderships().thenApply(leaderships -> Maps.transformValues((Map)leaderships, leadership -> leadership.map(this.valueDecoder)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.computeIfAbsent(listener, k -> new InternalLeadershipEventListener(listener));
            return this.backingElector.addListener(internalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.remove(listener);
            if (internalListener != null) {
                return this.backingElector.removeListener(internalListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(String topic, LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.computeIfAbsent(listener, k -> new InternalLeadershipEventListener(listener));
            return this.backingElector.addListener(topic, internalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(String topic, LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.remove(listener);
            if (internalListener != null) {
                return this.backingElector.removeListener(topic, internalListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public LeaderElector<V1> sync(Duration operationTimeout) {
        return new BlockingLeaderElector(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingElector", this.backingElector).toString();
    }

    private class InternalLeadershipEventListener
    implements LeadershipEventListener<V2> {
        private final LeadershipEventListener<V1> listener;

        InternalLeadershipEventListener(LeadershipEventListener<V1> listener) {
            this.listener = listener;
        }

        public void event(LeadershipEvent<V2> event) {
            this.listener.event((Event)new LeadershipEvent((LeadershipEvent.Type)event.type(), event.topic(), event.oldLeadership() != null ? event.oldLeadership().map(TranscodingAsyncLeaderElector.this.valueDecoder) : null, event.newLeadership() != null ? event.newLeadership().map(TranscodingAsyncLeaderElector.this.valueDecoder) : null));
        }
    }
}

