/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator.impl;

import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.CloseFunction;
import io.atomix.core.iterator.impl.NextFunction;
import io.atomix.core.iterator.impl.OpenFunction;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class PartitionedProxyIterator<S, T>
implements AsyncIterator<T> {
    private final Iterator<AsyncIterator<T>> partitions;
    private volatile AsyncIterator<T> iterator;
    private AtomicBoolean closed = new AtomicBoolean();

    public PartitionedProxyIterator(ProxyClient<S> client, OpenFunction<S, T> openFunction, NextFunction<S, T> nextFunction, CloseFunction<S> closeFunction) {
        this.partitions = client.getPartitionIds().stream().map(partitionId -> new ProxyIterator(client, (PartitionId)partitionId, openFunction, nextFunction, closeFunction)).collect(Collectors.toList()).iterator();
        this.iterator = this.partitions.next();
    }

    @Override
    public CompletableFuture<Boolean> hasNext() {
        return this.iterator.hasNext().thenCompose(hasNext -> {
            if (!hasNext.booleanValue()) {
                if (this.partitions.hasNext()) {
                    if (this.closed.get()) {
                        return Futures.exceptionalFuture((Throwable)new IllegalStateException("Iterator closed"));
                    }
                    this.iterator = this.partitions.next();
                    return this.hasNext();
                }
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public CompletableFuture<T> next() {
        return this.iterator.next();
    }

    @Override
    public CompletableFuture<Void> close() {
        this.closed.set(true);
        return this.iterator.close();
    }
}

