/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncAtomicSortedMap;
import io.atomix.core.map.AtomicSortedMap;
import io.atomix.core.map.impl.BlockingAtomicMap;

public class BlockingAtomicSortedMap<K extends Comparable<K>, V>
extends BlockingAtomicMap<K, V>
implements AtomicSortedMap<K, V> {
    private final AsyncAtomicSortedMap<K, V> asyncMap;
    private final long operationTimeoutMillis;

    public BlockingAtomicSortedMap(AsyncAtomicSortedMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap, operationTimeoutMillis);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public K firstKey() {
        return (K)((Comparable)this.complete(this.asyncMap.firstKey()));
    }

    @Override
    public K lastKey() {
        return (K)((Comparable)this.complete(this.asyncMap.lastKey()));
    }

    @Override
    public AtomicSortedMap<K, V> subMap(K fromKey, K toKey) {
        return new BlockingAtomicSortedMap<K, V>(this.asyncMap.subMap(fromKey, toKey), this.operationTimeoutMillis);
    }

    @Override
    public AtomicSortedMap<K, V> headMap(K toKey) {
        return new BlockingAtomicSortedMap<K, V>(this.asyncMap.headMap(toKey), this.operationTimeoutMillis);
    }

    @Override
    public AtomicSortedMap<K, V> tailMap(K fromKey) {
        return new BlockingAtomicSortedMap<K, V>(this.asyncMap.tailMap(fromKey), this.operationTimeoutMillis);
    }

    @Override
    public AsyncAtomicSortedMap<K, V> async() {
        return this.asyncMap;
    }
}

