/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.MapEvent;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TranscodingAsyncDistributedMap<K1, V1, K2, V2>
extends DelegatingAsyncPrimitive
implements AsyncDistributedMap<K1, V1> {
    private final AsyncDistributedMap<K2, V2> backingMap;
    private final Function<K1, K2> keyEncoder;
    private final Function<K2, K1> keyDecoder;
    private final Function<V2, V1> valueDecoder;
    private final Function<V1, V2> valueEncoder;
    private final Function<Map.Entry<K2, V2>, Map.Entry<K1, V1>> entryDecoder;
    private final Function<Map.Entry<K1, V1>, Map.Entry<K2, V2>> entryEncoder;
    private final Map<MapEventListener<K1, V1>, InternalBackingMapEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncDistributedMap(AsyncDistributedMap<K2, V2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingMap);
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.entryDecoder = e -> e == null ? null : Maps.immutableEntry(keyDecoder.apply(e.getKey()), valueDecoder.apply(e.getValue()));
        this.entryEncoder = e -> e == null ? null : Maps.immutableEntry(keyEncoder.apply(e.getKey()), valueEncoder.apply(e.getValue()));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K1 key) {
        try {
            return this.backingMap.containsKey(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V1 value) {
        try {
            return this.backingMap.containsValue(this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V1> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V1> getOrDefault(K1 key, V1 defaultValue) {
        try {
            return this.backingMap.getOrDefault(this.keyEncoder.apply(key), this.valueEncoder.apply(defaultValue)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V1> put(K1 key, V1 value) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K1, ? extends V1> map) {
        return this.backingMap.putAll(map.entrySet().stream().map(e -> this.entryEncoder.apply((Map.Entry<K1, V1>)e)).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue())));
    }

    @Override
    public CompletableFuture<V1> remove(K1 key) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V1> computeIfAbsent(K1 key, Function<? super K1, ? extends V1> mappingFunction) {
        return this.backingMap.computeIfAbsent(this.keyEncoder.apply(key), (? super K k) -> this.valueEncoder.apply(mappingFunction.apply((K1)this.keyDecoder.apply(k)))).thenApply(this.valueDecoder);
    }

    @Override
    public CompletableFuture<V1> computeIfPresent(K1 key, BiFunction<? super K1, ? super V1, ? extends V1> remappingFunction) {
        return this.backingMap.computeIfPresent(this.keyEncoder.apply(key), (? super K k, ? super V v) -> this.valueEncoder.apply(remappingFunction.apply((K1)this.keyDecoder.apply(k), (V1)this.valueDecoder.apply(v)))).thenApply(this.valueDecoder);
    }

    @Override
    public CompletableFuture<V1> compute(K1 key, BiFunction<? super K1, ? super V1, ? extends V1> remappingFunction) {
        return this.backingMap.compute(this.keyEncoder.apply(key), (? super K k, ? super V v) -> this.valueEncoder.apply(remappingFunction.apply((K1)this.keyDecoder.apply(k), (V1)this.valueDecoder.apply(v)))).thenApply(this.valueDecoder);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    @Override
    public AsyncDistributedSet<K1> keySet() {
        return new TranscodingAsyncDistributedSet<K1, K2>(this.backingMap.keySet(), this.keyEncoder, this.keyDecoder);
    }

    @Override
    public AsyncDistributedCollection<V1> values() {
        return new TranscodingAsyncDistributedCollection<V1, V2>(this.backingMap.values(), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncDistributedSet<Map.Entry<K1, V1>> entrySet() {
        return new TranscodingAsyncDistributedSet<Map.Entry<K1, V1>, Map.Entry<K2, V2>>(this.backingMap.entrySet(), this.entryEncoder, this.entryDecoder);
    }

    @Override
    public CompletableFuture<V1> putIfAbsent(K1 key, V1 value) {
        try {
            return this.backingMap.putIfAbsent(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> remove(K1 key, V1 value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V1> replace(K1 key, V1 value) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.valueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> replace(K1 key, V1 oldValue, V1 newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(oldValue), this.valueEncoder.apply(newValue));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(MapEventListener<K1, V1> listener, Executor executor) {
        Map<MapEventListener<K1, V1>, InternalBackingMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingMapEventListener backingMapListener = this.listeners.computeIfAbsent(listener, (? super K k) -> new InternalBackingMapEventListener(listener));
            return this.backingMap.addListener(backingMapListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(MapEventListener<K1, V1> listener) {
        Map<MapEventListener<K1, V1>, InternalBackingMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingMapEventListener backingMapListener = this.listeners.remove(listener);
            if (backingMapListener != null) {
                return this.backingMap.removeListener(backingMapListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public DistributedMap<K1, V1> sync(Duration operationTimeout) {
        return new BlockingDistributedMap(this, operationTimeout.toMillis());
    }

    private class InternalBackingMapEventListener
    implements MapEventListener<K2, V2> {
        private final MapEventListener<K1, V1> listener;

        InternalBackingMapEventListener(MapEventListener<K1, V1> listener) {
            this.listener = listener;
        }

        public void event(MapEvent<K2, V2> event) {
            this.listener.event((Event)new MapEvent((MapEvent.Type)event.type(), TranscodingAsyncDistributedMap.this.keyDecoder.apply(event.key()), (event.newValue() != null ? (Object)TranscodingAsyncDistributedMap.this.valueDecoder.apply(event.newValue()) : null), (event.oldValue() != null ? (Object)TranscodingAsyncDistributedMap.this.valueDecoder.apply(event.oldValue()) : null)));
        }
    }
}

