/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.Multiset;
import io.atomix.core.collection.impl.UnmodifiableAsyncDistributedCollection;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class UnmodifiableAsyncDistributedMultiset<E>
extends UnmodifiableAsyncDistributedCollection<E>
implements AsyncDistributedMultiset<E> {
    private static final String ERROR_MSG = "updates are not allowed";
    private final AsyncDistributedMultiset<E> asyncMultiset;

    public UnmodifiableAsyncDistributedMultiset(AsyncDistributedMultiset<E> delegateCollection) {
        super(delegateCollection);
        this.asyncMultiset = delegateCollection;
    }

    @Override
    public CompletableFuture<Integer> count(Object element) {
        return this.asyncMultiset.count(element);
    }

    @Override
    public CompletableFuture<Integer> add(E element, int occurrences) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Integer> remove(Object element, int occurrences) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Integer> setCount(E element, int count) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public CompletableFuture<Boolean> setCount(E element, int oldCount, int newCount) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException(ERROR_MSG));
    }

    @Override
    public AsyncDistributedSet<E> elementSet() {
        return this.asyncMultiset.elementSet();
    }

    @Override
    public AsyncDistributedSet<Multiset.Entry<E>> entrySet() {
        return this.asyncMultiset.entrySet();
    }

    @Override
    public DistributedMultiset<E> sync(Duration operationTimeout) {
        return new BlockingDistributedMultiset(this, operationTimeout.toMillis());
    }
}

