/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import io.atomix.core.cache.CacheConfig;
import io.atomix.core.collection.impl.CachingAsyncDistributedCollection;
import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.impl.BlockingDistributedQueue;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class CachingAsyncDistributedQueue<E>
extends CachingAsyncDistributedCollection<E>
implements AsyncDistributedQueue<E> {
    private final AsyncDistributedQueue<E> backingQueue;

    public CachingAsyncDistributedQueue(AsyncDistributedQueue<E> backingCollection, CacheConfig cacheConfig) {
        super(backingCollection, cacheConfig);
        this.backingQueue = backingCollection;
    }

    @Override
    public CompletableFuture<Boolean> offer(E e) {
        return this.backingQueue.offer(e);
    }

    @Override
    public CompletableFuture<E> remove() {
        return this.backingQueue.remove().thenApply(result -> {
            this.cache.invalidate(result);
            return result;
        });
    }

    @Override
    public CompletableFuture<E> poll() {
        return this.backingQueue.poll().thenApply(result -> {
            this.cache.invalidate(result);
            return result;
        });
    }

    @Override
    public CompletableFuture<E> element() {
        return this.backingQueue.element().thenApply(result -> {
            this.cache.invalidate(result);
            return result;
        });
    }

    @Override
    public CompletableFuture<E> peek() {
        return this.backingQueue.peek();
    }

    @Override
    public DistributedQueue<E> sync(Duration operationTimeout) {
        return new BlockingDistributedQueue(this, operationTimeout.toMillis());
    }
}

