/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.impl.BlockingDistributedQueue;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncDistributedQueue<E1, E2>
extends TranscodingAsyncDistributedCollection<E1, E2>
implements AsyncDistributedQueue<E1> {
    private final AsyncDistributedQueue<E2> backingQueue;
    private final Function<E1, E2> elementEncoder;
    private final Function<E2, E1> elementDecoder;

    public TranscodingAsyncDistributedQueue(AsyncDistributedQueue<E2> backingQueue, Function<E1, E2> elementEncoder, Function<E2, E1> elementDecoder) {
        super(backingQueue, elementEncoder, elementDecoder);
        this.backingQueue = backingQueue;
        this.elementEncoder = k -> k == null ? null : elementEncoder.apply(k);
        this.elementDecoder = k -> k == null ? null : elementDecoder.apply(k);
    }

    @Override
    public CompletableFuture<Boolean> offer(E1 element) {
        return this.backingQueue.offer(this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<E1> remove() {
        return this.backingQueue.remove().thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<E1> poll() {
        return this.backingQueue.poll().thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<E1> element() {
        return this.backingQueue.element().thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<E1> peek() {
        return this.backingQueue.peek().thenApply(this.elementDecoder);
    }

    @Override
    public DistributedQueue<E1> sync(Duration operationTimeout) {
        return new BlockingDistributedQueue(this, operationTimeout.toMillis());
    }
}

