/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.core.AtomixRegistry;
import io.atomix.utils.ConfiguredType;
import io.atomix.utils.NamedType;
import io.atomix.utils.ServiceException;
import io.atomix.utils.misc.StringUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningRegistry
implements AtomixRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningRegistry.class);
    private static final Map<ClassLoader, Map<Class<? extends NamedType>, Map<String, NamedType>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends NamedType>, Map<String, NamedType>> registrations = new ConcurrentHashMap<Class<? extends NamedType>, Map<String, NamedType>>();

    public static Builder builder() {
        return new Builder();
    }

    private ClasspathScanningRegistry(ClassLoader classLoader) {
        this(classLoader, Sets.newHashSet());
    }

    private ClasspathScanningRegistry(ClassLoader classLoader, Set<String> whitelistPackages) {
        Map registrations = CACHE.computeIfAbsent(classLoader, cl -> {
            ClassGraph classGraph = !whitelistPackages.isEmpty() ? new ClassGraph().enableClassInfo().whitelistPackages(whitelistPackages.toArray(new String[0])).addClassLoader(classLoader) : new ClassGraph().enableClassInfo().addClassLoader(classLoader);
            try (ScanResult scanResult = classGraph.scan();){
                ConcurrentHashMap result = new ConcurrentHashMap();
                scanResult.getClassesImplementing(NamedType.class.getName()).forEach(classInfo -> {
                    if (classInfo.isInterface() || classInfo.isAbstract() || Modifier.isPrivate(classInfo.getModifiers())) {
                        return;
                    }
                    Class type = classInfo.loadClass();
                    Class<? extends NamedType> classType = this.getClassType(type);
                    NamedType instance = (NamedType)ClasspathScanningRegistry.newInstance(type);
                    NamedType oldInstance = result.computeIfAbsent(classType, t -> new HashMap()).put(instance.name(), instance);
                    if (oldInstance != null) {
                        LOGGER.warn("Found multiple types with name={}, classes=[{}, {}]", new Object[]{instance.name(), oldInstance.getClass().getName(), instance.getClass().getName()});
                    }
                });
                ConcurrentHashMap concurrentHashMap = result;
                return concurrentHashMap;
            }
        });
        this.registrations.putAll(registrations);
    }

    private Class<? extends NamedType> getClassType(Class<?> type) {
        while (type != Object.class) {
            Class<? extends NamedType> baseType = this.getInterfaceType(type);
            if (baseType != null) {
                return baseType;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private Class<? extends NamedType> getInterfaceType(Class<?> type) {
        for (Class<?> iface : type.getInterfaces()) {
            if (iface != ConfiguredType.class && iface != NamedType.class) continue;
            return type;
        }
        for (Class<?> iface : type.getInterfaces()) {
            type = this.getInterfaceType(iface);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public <T extends NamedType> Collection<T> getTypes(Class<T> type) {
        Map<String, NamedType> types = this.registrations.get(type);
        return types != null ? types.values() : Collections.emptyList();
    }

    @Override
    public <T extends NamedType> T getType(Class<T> type, String name) {
        Map<String, NamedType> types = this.registrations.get(type);
        return (T)(types != null ? types.get(name) : null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<AtomixRegistry> {
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private Set<String> whitelistPackages = Sets.newHashSet();

        private Builder() {
            String whitelistPackages = System.getProperty("io.atomix.whitelistPackages");
            if (whitelistPackages != null) {
                this.whitelistPackages = Sets.newHashSet((Object[])StringUtils.split((String)whitelistPackages, (String)","));
            }
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader cannot be null");
            return this;
        }

        public Builder withWhitelistPackages(String ... whitelistPackages) {
            return this.withWhitelistPackages(Sets.newHashSet((Object[])whitelistPackages));
        }

        public Builder withWhitelistPackages(Collection<String> whitelistPackages) {
            this.whitelistPackages = Sets.newHashSet(whitelistPackages);
            return this;
        }

        public Builder addWhitelistPackage(String whitelistPackage) {
            Preconditions.checkNotNull((Object)whitelistPackage, (Object)"whitelistPackage cannot be null");
            this.whitelistPackages.add(whitelistPackage);
            return this;
        }

        public AtomixRegistry build() {
            return new ClasspathScanningRegistry(this.classLoader, this.whitelistPackages);
        }
    }
}

