/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import io.atomix.core.semaphore.AsyncAtomicSemaphore;
import io.atomix.core.semaphore.AtomicSemaphore;
import io.atomix.core.semaphore.QueueStatus;
import io.atomix.core.semaphore.impl.AtomicSemaphoreClient;
import io.atomix.core.semaphore.impl.AtomicSemaphoreService;
import io.atomix.core.semaphore.impl.BlockingAtomicSemaphore;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.time.Version;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class AtomicSemaphoreProxy
extends AbstractAsyncPrimitive<AsyncAtomicSemaphore, AtomicSemaphoreService>
implements AsyncAtomicSemaphore,
AtomicSemaphoreClient {
    private static final Duration NO_TIMEOUT = Duration.ofMillis(-1L);
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<Long, AcquireAttempt> attempts = new ConcurrentHashMap<Long, AcquireAttempt>();
    private final AtomicLong attemptId = new AtomicLong();

    public AtomicSemaphoreProxy(ProxyClient<AtomicSemaphoreService> proxy, PrimitiveRegistry registry, ScheduledExecutorService scheduledExecutor) {
        super(proxy, registry);
        this.scheduledExecutor = scheduledExecutor;
    }

    @Override
    public void succeeded(long id, long version, int permits) {
        AcquireAttempt attempt = this.attempts.remove(id);
        if (attempt == null) {
            this.release(permits);
        } else {
            attempt.complete(new Version(version));
        }
    }

    @Override
    public void failed(long id) {
        this.onExpired(id);
    }

    private void onExpired(long id) {
        AcquireAttempt attempt = this.attempts.remove(id);
        if (attempt != null) {
            attempt.complete(null);
        }
    }

    @Override
    public CompletableFuture<Version> acquire() {
        return this.acquire(1);
    }

    @Override
    public CompletableFuture<Version> acquire(int permits) {
        return this.tryAcquire(permits, NO_TIMEOUT).thenApply(Optional::get);
    }

    @Override
    public CompletableFuture<Optional<Version>> tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public CompletableFuture<Optional<Version>> tryAcquire(int permits) {
        return this.tryAcquire(permits, Duration.ZERO);
    }

    @Override
    public CompletableFuture<Optional<Version>> tryAcquire(Duration timeout) {
        return this.tryAcquire(1, timeout);
    }

    @Override
    public CompletableFuture<Optional<Version>> tryAcquire(int permits, Duration timeout) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        long id = this.attemptId.incrementAndGet();
        AcquireAttempt attempt = new AcquireAttempt(id, permits, timeout, a -> this.onExpired(a.id()));
        this.attempts.put(id, attempt);
        this.getProxyClient().acceptBy(this.name(), service -> service.acquire(attempt.id(), permits, timeout.toMillis())).whenComplete((result, error) -> {
            if (error != null) {
                this.attempts.remove(id);
                attempt.complete(null);
            }
        });
        return attempt.thenApply(Optional::ofNullable);
    }

    @Override
    public CompletableFuture<Void> release() {
        return this.release(1);
    }

    @Override
    public CompletableFuture<Void> release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.getProxyClient().acceptBy(this.name(), service -> service.release(permits));
    }

    @Override
    public CompletableFuture<Integer> availablePermits() {
        return this.getProxyClient().applyBy(this.name(), service -> service.available());
    }

    @Override
    public CompletableFuture<Integer> drainPermits() {
        return this.getProxyClient().applyBy(this.name(), service -> service.drain());
    }

    @Override
    public CompletableFuture<Integer> increasePermits(int permits) {
        return this.getProxyClient().applyBy(this.name(), service -> service.increase(permits));
    }

    @Override
    public CompletableFuture<Integer> reducePermits(int permits) {
        return this.getProxyClient().applyBy(this.name(), service -> service.reduce(permits));
    }

    @Override
    public CompletableFuture<QueueStatus> queueStatus() {
        return this.getProxyClient().applyBy(this.name(), service -> service.queueStatus());
    }

    public CompletableFuture<AsyncAtomicSemaphore> connect() {
        return ((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenApply(v -> this);
    }

    @Override
    public AtomicSemaphore sync(Duration operationTimeout) {
        return new BlockingAtomicSemaphore(this, operationTimeout);
    }

    public CompletableFuture<Map<Long, Integer>> holderStatus() {
        return this.getProxyClient().applyBy(this.name(), service -> service.holderStatus());
    }

    private class AcquireAttempt
    extends CompletableFuture<Version> {
        private final long id;
        private final int permits;
        private ScheduledFuture<?> scheduledFuture;

        AcquireAttempt(long id, int permits) {
            this.id = id;
            this.permits = permits;
        }

        AcquireAttempt(long id, int permits, Duration timeout, Consumer<AcquireAttempt> callback) {
            this(id, permits);
            this.scheduledFuture = timeout != null && callback != null && timeout.toMillis() > 0L ? atomicSemaphoreProxy.scheduledExecutor.schedule(() -> callback.accept(this), timeout.toMillis(), TimeUnit.MILLISECONDS) : null;
        }

        public long id() {
            return this.id;
        }

        public int permits() {
            return this.permits;
        }

        @Override
        public boolean complete(Version version) {
            if (this.isDone()) {
                return super.complete(null);
            }
            this.cancel();
            if (version != null) {
                return super.complete(version);
            }
            return super.complete(null);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cancel();
            return super.completeExceptionally(ex);
        }

        private void cancel() {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
        }
    }
}

