/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSetBuilder;
import io.atomix.core.set.DistributedNavigableSetConfig;
import io.atomix.core.set.impl.CachingAsyncDistributedNavigableSet;
import io.atomix.core.set.impl.DistributedNavigableSetProxy;
import io.atomix.core.set.impl.DistributedTreeSetService;
import io.atomix.core.set.impl.GossipDistributedNavigableSet;
import io.atomix.core.set.impl.UnmodifiableAsyncDistributedNavigableSet;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.set.NavigableSetProtocol;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedNavigableSetBuilder<E extends Comparable<E>>
extends DistributedNavigableSetBuilder<E> {
    public DefaultDistributedNavigableSetBuilder(String name, DistributedNavigableSetConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedNavigableSet<E>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof NavigableSetProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((NavigableSetProtocol)protocol).newNavigableSetDelegate(this.name, this.serializer(), this.managementService)).thenApply(set -> new GossipDistributedNavigableSet(this.name, protocol, set))).thenApply(AsyncDistributedNavigableSet::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Sets are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)this.newProxy(DistributedTreeSetService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedNavigableSetProxy(proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(set -> {
            if (((DistributedNavigableSetConfig)this.config).getCacheConfig().isEnabled()) {
                set = new CachingAsyncDistributedNavigableSet(set, ((DistributedNavigableSetConfig)this.config).getCacheConfig());
            }
            if (((DistributedNavigableSetConfig)this.config).isReadOnly()) {
                set = new UnmodifiableAsyncDistributedNavigableSet(set);
            }
            return set.sync();
        });
    }
}

