/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import com.google.common.base.MoreObjects;
import java.util.function.Function;

public class SetUpdate<E> {
    private final Type type;
    private final E element;

    public SetUpdate(Type type, E element) {
        this.type = type;
        this.element = element;
    }

    public Type type() {
        return this.type;
    }

    public E element() {
        return this.element;
    }

    public <T> SetUpdate<T> map(Function<E, T> mapper) {
        return new SetUpdate<T>(this.type, mapper.apply(this.element));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("element", this.element).toString();
    }

    public static enum Type {
        ADD,
        REMOVE,
        CONTAINS,
        NOT_CONTAINS;

    }
}

